/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer;

import com.google.common.reflect.ClassPath;
import eu.solven.cleanthat.engine.java.refactorer.meta.IMutator;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutatorsScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(MutatorsScanner.class);

    public List<IMutator> getMutators() {
        Set<String> classes;
        String packageName = "eu.solven.cleanthat.engine.java.refactorer.mutators";
        try {
            classes = MutatorsScanner.getClasses(packageName);
        }
        catch (IOException | ClassNotFoundException e) {
            LOGGER.error("Issue loading mutators from {}", (Object)packageName, (Object)e);
            return Collections.emptyList();
        }
        if (classes.isEmpty()) {
            LOGGER.error("CleanThat failed detecting a single mutator in {}", (Object)packageName);
        }
        return classes.stream().map(s -> {
            try {
                return Class.forName(s);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("Issue with {}", s, (Object)e);
                return null;
            }
        }).filter(c -> c != null).filter(c -> IMutator.class.isAssignableFrom((Class<?>)c)).map(c -> {
            try {
                return c.asSubclass(IMutator.class).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                LOGGER.error("Issue with {}", c, (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static Set<String> getClasses(String packageName) throws ClassNotFoundException, IOException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        TreeSet<String> classNames = new TreeSet<String>();
        try {
            ClassPath classpath = ClassPath.from((ClassLoader)loader);
            for (ClassPath.ClassInfo classInfo : classpath.getTopLevelClasses(packageName)) {
                classNames.add(classInfo.getName());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Issue with " + packageName, e);
        }
        return classNames;
    }
}

