/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.meta;

import java.util.Objects;

public class VersionWrapper
implements Comparable<VersionWrapper> {
    final String version;

    public final String get() {
        return this.version;
    }

    public VersionWrapper(String version) {
        if (version == null) {
            throw new IllegalArgumentException("Version can not be null");
        }
        if (!version.matches("[0-9]+(\\.[0-9]+)*")) {
            throw new IllegalArgumentException("Invalid version format");
        }
        this.version = version;
    }

    @Override
    public int compareTo(VersionWrapper that) {
        if (that == null) {
            return 1;
        }
        String[] thisParts = this.get().split("\\.");
        String[] thatParts = that.get().split("\\.");
        int length = Math.max(thisParts.length, thatParts.length);
        for (int i = 0; i < length; ++i) {
            int thatPart;
            int thisPart = this.getPart(thisParts, i);
            if (thisPart < (thatPart = this.getPart(thatParts, i))) {
                return -1;
            }
            if (thisPart <= thatPart) continue;
            return 1;
        }
        return 0;
    }

    private int getPart(String[] thisParts, int i) {
        int thisPart = i < thisParts.length ? Integer.parseInt(thisParts[i]) : 0;
        return thisPart;
    }

    public int hashCode() {
        return Objects.hash(this.version);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (this.getClass() != that.getClass()) {
            return false;
        }
        return this.compareTo((VersionWrapper)that) == 0;
    }
}

