/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import eu.solven.cleanthat.engine.java.refactorer.AJavaParserMutator;
import eu.solven.cleanthat.engine.java.refactorer.meta.IMutator;
import eu.solven.cleanthat.engine.java.refactorer.mutators.StreamAnyMatch;
import eu.solven.pepper.logging.PepperLogHelper;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArraysDotStream
extends AJavaParserMutator
implements IMutator {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamAnyMatch.class);
    private static final String METHOD_ASLIST = "asList";
    private static final String METHOD_STREAM = "stream";

    @Override
    public String minimalJavaVersion() {
        return "1.8";
    }

    @Override
    public boolean isProductionReady() {
        return true;
    }

    @Override
    public String getId() {
        return "ArraysDotStream";
    }

    @Override
    public String jsparrowUrl() {
        return "https://jsparrow.github.io/rules/use-arrays-stream.html";
    }

    @Override
    protected boolean processNotRecursively(Node node) {
        LOGGER.debug("{}", PepperLogHelper.getObjectAndClass((Object)node));
        if (!(node instanceof MethodCallExpr)) {
            return false;
        }
        MethodCallExpr methodCall = (MethodCallExpr)node;
        String methodCallIdentifier = methodCall.getNameAsString();
        if (!METHOD_STREAM.equals(methodCallIdentifier)) {
            return false;
        }
        Optional optScope = methodCall.getScope();
        if (optScope.isEmpty()) {
            return false;
        }
        Expression scope = (Expression)optScope.get();
        if (!(scope instanceof MethodCallExpr)) {
            return false;
        }
        MethodCallExpr scopeAsMethodCallExpr = (MethodCallExpr)scope;
        if (!METHOD_ASLIST.equals(scopeAsMethodCallExpr.getName().getIdentifier())) {
            return false;
        }
        Optional optParentScope = scopeAsMethodCallExpr.getScope();
        if (optParentScope.isEmpty()) {
            return false;
        }
        Expression parentScope = (Expression)optParentScope.get();
        if (!parentScope.isNameExpr()) {
            return false;
        }
        if (scopeAsMethodCallExpr.getArguments().size() != 1) {
            return false;
        }
        Expression filterPredicate = scopeAsMethodCallExpr.getArgument(0);
        boolean localTransformed = false;
        NodeList replaceArguments = new NodeList((Node[])new Expression[]{filterPredicate});
        MethodCallExpr replacement = new MethodCallExpr(parentScope, METHOD_STREAM, replaceArguments);
        LOGGER.info("Turning {} into {}", (Object)methodCall, (Object)replacement);
        if (methodCall.replace((Node)replacement)) {
            localTransformed = true;
        }
        return localTransformed;
    }
}

