/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import eu.solven.cleanthat.engine.java.refactorer.AJavaParserMutator;
import eu.solven.cleanthat.engine.java.refactorer.meta.IMutator;
import eu.solven.pepper.logging.PepperLogHelper;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComparisonWithNaN
extends AJavaParserMutator
implements IMutator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComparisonWithNaN.class);

    @Override
    public String minimalJavaVersion() {
        return "11";
    }

    @Override
    public boolean isProductionReady() {
        return true;
    }

    @Override
    public String getId() {
        return "ComparisonWithNaN";
    }

    @Override
    public String pmdUrl() {
        return "https://pmd.github.io/latest/pmd_rules_java_errorprone.html#comparisonwithnan";
    }

    @Override
    protected boolean processNotRecursively(Node node) {
        MethodCallExpr replacement;
        Class methodHolderClass;
        boolean prefixNullCheck;
        Expression mayNotBeNaN;
        LOGGER.debug("{}", PepperLogHelper.getObjectAndClass((Object)node));
        if (!(node instanceof BinaryExpr)) {
            return false;
        }
        BinaryExpr binaryExpr = (BinaryExpr)node;
        if (binaryExpr.getOperator() != BinaryExpr.Operator.EQUALS) {
            return false;
        }
        Expression left = binaryExpr.getLeft();
        Expression right = binaryExpr.getRight();
        if (this.isNaNReference(right)) {
            mayNotBeNaN = left;
        } else if (this.isNaNReference(left)) {
            mayNotBeNaN = right;
        } else {
            return false;
        }
        if (this.scopeHasRequiredType(Optional.of(mayNotBeNaN), Float.TYPE)) {
            prefixNullCheck = false;
            methodHolderClass = Float.class;
        } else if (this.scopeHasRequiredType(Optional.of(mayNotBeNaN), Double.TYPE)) {
            prefixNullCheck = false;
            methodHolderClass = Double.class;
        } else if (this.scopeHasRequiredType(Optional.of(mayNotBeNaN), Float.class)) {
            prefixNullCheck = true;
            methodHolderClass = Float.class;
        } else if (this.scopeHasRequiredType(Optional.of(mayNotBeNaN), Double.class)) {
            prefixNullCheck = true;
            methodHolderClass = Double.class;
        } else {
            return false;
        }
        NameExpr nameExpr = new NameExpr(methodHolderClass.getSimpleName());
        MethodCallExpr properNaNCall = new MethodCallExpr((Expression)nameExpr, "isNaN", new NodeList((Node[])new Expression[]{mayNotBeNaN}));
        if (prefixNullCheck) {
            BinaryExpr notNull = new BinaryExpr(mayNotBeNaN, (Expression)new NullLiteralExpr(), BinaryExpr.Operator.NOT_EQUALS);
            replacement = new BinaryExpr((Expression)notNull, (Expression)properNaNCall, BinaryExpr.Operator.AND);
        } else {
            replacement = properNaNCall;
        }
        return node.replace((Node)replacement);
    }

    private boolean isNaNReference(Expression left) {
        if (!left.isFieldAccessExpr()) {
            return false;
        }
        FieldAccessExpr fieldAccessExpr = left.asFieldAccessExpr();
        if (!"NaN".equals(fieldAccessExpr.getNameAsString())) {
            return false;
        }
        return this.scopeHasRequiredType(Optional.of(fieldAccessExpr.getScope()), Double.class) || this.scopeHasRequiredType(Optional.of(fieldAccessExpr.getScope()), Float.class);
    }
}

