/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.UnaryExpr;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import eu.solven.cleanthat.engine.java.refactorer.AJavaParserMutator;
import eu.solven.cleanthat.engine.java.refactorer.meta.IMutator;
import eu.solven.pepper.logging.PepperLogHelper;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumsWithoutEquals
extends AJavaParserMutator
implements IMutator {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnumsWithoutEquals.class);

    @Override
    public String minimalJavaVersion() {
        return "1.5";
    }

    @Override
    public String getId() {
        return "EnumsWithoutEquals";
    }

    @Override
    public String jsparrowUrl() {
        return "https://jsparrow.github.io/rules/enums-without-equals.html";
    }

    @Override
    protected boolean processNotRecursively(Node node) {
        LOGGER.debug("{}", PepperLogHelper.getObjectAndClass((Object)node));
        AtomicBoolean mutated = new AtomicBoolean(false);
        this.onMethodName(node, "equals", (methodCall, scope, type) -> {
            if (type.isReferenceType()) {
                boolean isEnum = false;
                ResolvedReferenceType referenceType = type.asReferenceType();
                referenceType.isJavaLangEnum();
                String className = referenceType.getQualifiedName();
                try {
                    Class<?> clazz = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
                    isEnum = Enum.class.isAssignableFrom(clazz);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.debug("Class is not available", (Throwable)e);
                }
                if (isEnum && methodCall.getArguments().size() == 1) {
                    BinaryExpr replacement;
                    Node parent;
                    Expression singleArgument = methodCall.getArgument(0);
                    Optional optParentNode = methodCall.getParentNode();
                    boolean isNegated = optParentNode.isPresent() ? (parent = (Node)optParentNode.get()) instanceof UnaryExpr && ((UnaryExpr)parent).getOperator() == UnaryExpr.Operator.LOGICAL_COMPLEMENT : false;
                    if (isNegated) {
                        replacement = new BinaryExpr(scope, singleArgument, BinaryExpr.Operator.NOT_EQUALS);
                        if (this.tryReplace((Node)optParentNode.get(), (Node)replacement)) {
                            mutated.set(true);
                        }
                    } else {
                        replacement = new BinaryExpr(scope, singleArgument, BinaryExpr.Operator.EQUALS);
                        if (this.tryReplace(node, (Node)replacement)) {
                            mutated.set(true);
                        }
                    }
                }
            }
        });
        return mutated.get();
    }
}

