/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedAnnotationDeclaration;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.google.common.collect.ImmutableMap;
import eu.solven.cleanthat.engine.java.refactorer.AJavaParserMutator;
import eu.solven.cleanthat.engine.java.refactorer.meta.IMutator;
import eu.solven.pepper.logging.PepperLogHelper;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JUnit4ToJUnit5
extends AJavaParserMutator
implements IMutator {
    private static final Logger LOGGER = LoggerFactory.getLogger(JUnit4ToJUnit5.class);
    private static final String JAVA_LANG = "java.lang";
    private final Map<String, String> fromTo = ImmutableMap.builder().put((Object)"org.junit.Before", (Object)"org.junit.jupiter.api.BeforeEach").put((Object)"org.junit.After", (Object)"org.junit.jupiter.api.AfterEach").put((Object)"org.junit.BeforeClass", (Object)"org.junit.jupiter.api.BeforeAll").put((Object)"org.junit.AfterClass", (Object)"org.junit.jupiter.api.AfterAll").put((Object)"org.junit.Ignore", (Object)"org.junit.jupiter.api.Disabled").put((Object)"org.junit.Assert", (Object)"org.junit.jupiter.api.Assertions").put((Object)"org.junit.Test", (Object)"org.junit.jupiter.api.Test").build();

    @Override
    public String minimalJavaVersion() {
        return "1.8";
    }

    @Override
    public String getId() {
        return "JUnit4ToJupiter";
    }

    @Override
    public boolean isJreOnly() {
        return false;
    }

    @Override
    public boolean walkNode(Node tree) {
        AtomicBoolean transformed = new AtomicBoolean(false);
        if (super.walkNode(tree)) {
            transformed.set(true);
        }
        if (tree instanceof CompilationUnit) {
            CompilationUnit compilationUnit = (CompilationUnit)tree;
            compilationUnit.getImports().forEach(importNode -> {
                String importName = importNode.getName().asString();
                Optional<String> optMigratedName = this.computeNewName(importName);
                if (optMigratedName.isPresent()) {
                    importNode.setName(optMigratedName.get());
                    transformed.set(true);
                }
            });
        }
        return transformed.get();
    }

    @Override
    protected boolean processNotRecursively(Node node) {
        LOGGER.debug("{}", PepperLogHelper.getObjectAndClass((Object)node));
        boolean localTransformed = false;
        if (node instanceof AnnotationExpr) {
            localTransformed = this.processAnnotation((AnnotationExpr)node);
        } else if (node instanceof MethodCallExpr) {
            localTransformed = this.processMethodCall((MethodCallExpr)node);
        }
        return localTransformed;
    }

    private Optional<String> computeNewName(String importName) {
        Optional<String> optMigratedName = "org.junit".equals(importName) ? Optional.of("org.junit.jupiter.api") : Optional.ofNullable(this.fromTo.get(importName));
        return optMigratedName;
    }

    protected boolean processAnnotation(AnnotationExpr annotation) {
        ResolvedAnnotationDeclaration resolvedAnnotation;
        try {
            resolvedAnnotation = annotation.resolve();
        }
        catch (UnsolvedSymbolException e) {
            LOGGER.debug("We were not able to resolve annotation: {}", (Object)annotation);
            return false;
        }
        String qualifiedName = resolvedAnnotation.getQualifiedName();
        Optional<String> optMigratedName = this.computeNewName(qualifiedName);
        boolean localTransformed = false;
        if (optMigratedName.isPresent()) {
            localTransformed = true;
            String migratedName = optMigratedName.get();
            if (annotation.getName().asString().indexOf(46) >= 0) {
                annotation.setName(migratedName);
            } else {
                int lastDot = migratedName.lastIndexOf(46);
                if (lastDot < 0) {
                    annotation.setName(migratedName);
                } else {
                    annotation.setName(migratedName.substring(lastDot + 1));
                }
            }
        }
        return localTransformed;
    }

    private boolean processMethodCall(MethodCallExpr methodCall) {
        ResolvedReferenceType referenceType;
        String oldQualifiedName;
        Optional<String> optNewName;
        Optional optScope = methodCall.getScope();
        if (optScope.isEmpty()) {
            return false;
        }
        Expression scope = (Expression)optScope.get();
        Optional<ResolvedType> type = this.optResolvedType(scope);
        if (type.isPresent() && type.get().isReferenceType() && (optNewName = this.computeNewName(oldQualifiedName = (referenceType = type.get().asReferenceType()).getQualifiedName())).isPresent()) {
            NameExpr newScope;
            String newQualifiedName = optNewName.get();
            CompilationUnit compilationUnit = (CompilationUnit)methodCall.findAncestor(new Class[]{CompilationUnit.class}).get();
            boolean imported = this.isImported(compilationUnit, new ImportDeclaration(newQualifiedName, false, false));
            if (imported) {
                String newSimpleName = newQualifiedName.substring(newQualifiedName.lastIndexOf(46) + 1);
                newScope = new NameExpr(newSimpleName);
            } else {
                newScope = new NameExpr(newQualifiedName);
            }
            MethodCallExpr replacement = new MethodCallExpr((Expression)newScope, methodCall.getNameAsString(), methodCall.getArguments());
            return methodCall.replace((Node)replacement);
        }
        return false;
    }

    private boolean isImported(CompilationUnit compilationUnit, ImportDeclaration importDeclaration) {
        return !this.isImplicitImport(compilationUnit, importDeclaration) && compilationUnit.getImports().stream().noneMatch(im -> im.equals((Object)importDeclaration) || im.isAsterisk() && Objects.equals(JUnit4ToJUnit5.getImportPackageName(im).get(), JUnit4ToJUnit5.getImportPackageName(importDeclaration).orElse(null)));
    }

    private boolean isImplicitImport(CompilationUnit compilationUnit, ImportDeclaration importDeclaration) {
        Optional<Name> importPackageName = JUnit4ToJUnit5.getImportPackageName(importDeclaration);
        if (importPackageName.isPresent()) {
            if (StaticJavaParser.parseName((String)JAVA_LANG).equals((Object)importPackageName.get())) {
                return true;
            }
            if (compilationUnit.getPackageDeclaration().isPresent()) {
                Name currentPackageName = ((PackageDeclaration)compilationUnit.getPackageDeclaration().get()).getName();
                return currentPackageName.equals((Object)importPackageName.get());
            }
            return false;
        }
        return true;
    }

    private static Optional<Name> getImportPackageName(ImportDeclaration importDeclaration) {
        return (importDeclaration.isAsterisk() ? new Name(importDeclaration.getName(), "*") : importDeclaration.getName()).getQualifier();
    }
}

