/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.nodeTypes.NodeWithModifiers;
import com.google.common.collect.ImmutableList;
import eu.solven.cleanthat.engine.java.refactorer.AJavaParserMutator;
import eu.solven.cleanthat.engine.java.refactorer.meta.IMutator;
import eu.solven.cleanthat.engine.java.refactorer.meta.IRuleExternalUrls;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifierOrder
extends AJavaParserMutator
implements IMutator,
IRuleExternalUrls {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModifierOrder.class);
    private static final List<String> ORDERED_MODIFIERS = ImmutableList.of((Object)"public", (Object)"protected", (Object)"private", (Object)"abstract", (Object)"default", (Object)"static", (Object)"final", (Object)"transient", (Object)"volatile", (Object)"synchronized", (Object)"native", (Object)"strictfp", (Object[])new String[0]);

    @Override
    public String getId() {
        return "ModifierOrder";
    }

    @Override
    public String minimalJavaVersion() {
        return "1";
    }

    @Override
    public String checkstyleUrl() {
        return "https://checkstyle.sourceforge.io/apidocs/com/puppycrawl/tools/checkstyle/checks/modifier/ModifierOrderCheck.html";
    }

    @Override
    public String jsparrowUrl() {
        return "https://jsparrow.github.io/rules/reorder-modifiers.html";
    }

    @Override
    protected boolean processNotRecursively(Node node) {
        if (node instanceof NodeWithModifiers) {
            NodeWithModifiers nodeWithModifiers = (NodeWithModifiers)node;
            NodeList modifiers = nodeWithModifiers.getModifiers();
            NodeList mutableModifiers = new NodeList((Collection)modifiers);
            Collections.sort(mutableModifiers, new Comparator<Modifier>(){

                @Override
                public int compare(Modifier o1, Modifier o2) {
                    return this.compare2(o1.getKeyword().asString(), o1.getKeyword().asString());
                }

                private int compare2(String left, String right) {
                    return Integer.compare(ORDERED_MODIFIERS.indexOf(left), ORDERED_MODIFIERS.indexOf(right));
                }
            });
            boolean changed = this.areSameReferences((NodeList<Modifier>)modifiers, (NodeList<Modifier>)mutableModifiers);
            if (changed) {
                LOGGER.debug("We fixed the ordering of modifiers");
                nodeWithModifiers.setModifiers(mutableModifiers);
                return true;
            }
        }
        return false;
    }

    private boolean areSameReferences(NodeList<Modifier> modifiers, NodeList<Modifier> mutableModifiers) {
        boolean changed = false;
        for (int i = 0; i < modifiers.size(); ++i) {
            if (modifiers.get(i) == mutableModifiers.get(i)) continue;
            changed = true;
            break;
        }
        return changed;
    }
}

