/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.UnaryExpr;
import eu.solven.cleanthat.engine.java.refactorer.AJavaParserMutator;
import eu.solven.cleanthat.engine.java.refactorer.meta.IMutator;
import eu.solven.pepper.logging.PepperLogHelper;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptionalNotEmpty
extends AJavaParserMutator
implements IMutator {
    private static final Logger LOGGER = LoggerFactory.getLogger(OptionalNotEmpty.class);
    private static final String METHOD_IS_PRESENT = "isPresent";
    private static final String METHOD_IS_EMPTY = "isEmpty";

    @Override
    public String minimalJavaVersion() {
        return "11";
    }

    @Override
    public boolean isProductionReady() {
        return true;
    }

    @Override
    public String getId() {
        return "OptionalNotEmpty";
    }

    @Override
    protected boolean processNotRecursively(Node node) {
        LOGGER.debug("{}", PepperLogHelper.getObjectAndClass((Object)node));
        if (!(node instanceof MethodCallExpr)) {
            return false;
        }
        MethodCallExpr methodCall = (MethodCallExpr)node;
        String methodCallIdentifier = methodCall.getName().getIdentifier();
        if (!METHOD_IS_EMPTY.equals(methodCallIdentifier) && !METHOD_IS_PRESENT.equals(methodCallIdentifier)) {
            return false;
        }
        Optional optParent = methodCall.getParentNode();
        if (methodCall.getScope().isEmpty() || optParent.isEmpty() || !(optParent.get() instanceof UnaryExpr)) {
            return false;
        }
        UnaryExpr unaryExpr = (UnaryExpr)optParent.get();
        if (!"LOGICAL_COMPLEMENT".equals(unaryExpr.getOperator().name())) {
            return false;
        }
        Optional optScope = methodCall.getScope();
        if (!this.scopeHasRequiredType((Optional<Expression>)optScope, Optional.class)) {
            return false;
        }
        Expression scope = (Expression)optScope.get();
        String newMethod = METHOD_IS_EMPTY.equals(methodCallIdentifier) ? METHOD_IS_PRESENT : METHOD_IS_EMPTY;
        boolean localTransformed = false;
        MethodCallExpr replacement = new MethodCallExpr(scope, newMethod);
        LOGGER.info("Turning {} into {}", (Object)unaryExpr, (Object)replacement);
        if (unaryExpr.replace((Node)replacement)) {
            localTransformed = true;
        }
        return localTransformed;
    }
}

