/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import eu.solven.cleanthat.engine.java.refactorer.AJavaParserMutator;
import eu.solven.cleanthat.engine.java.refactorer.meta.IMutator;
import eu.solven.pepper.logging.PepperLogHelper;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringToString
extends AJavaParserMutator
implements IMutator {
    private static final Logger LOGGER = LoggerFactory.getLogger(StringToString.class);
    private static final String METHOD_TO_STRING = "toString";

    @Override
    public String minimalJavaVersion() {
        return "11";
    }

    @Override
    public String getId() {
        return "StringToString";
    }

    @Override
    public String pmdUrl() {
        return "https://pmd.github.io/latest/pmd_rules_java_performance.html#stringtostring";
    }

    @Override
    protected boolean processNotRecursively(Node node) {
        LOGGER.debug("{}", PepperLogHelper.getObjectAndClass((Object)node));
        if (!(node instanceof MethodCallExpr)) {
            return false;
        }
        MethodCallExpr methodCall = (MethodCallExpr)node;
        String methodCallIdentifier = methodCall.getName().getIdentifier();
        if (!METHOD_TO_STRING.equals(methodCallIdentifier)) {
            return false;
        }
        Optional optParent = methodCall.getParentNode();
        if (methodCall.getScope().isEmpty() || optParent.isEmpty()) {
            return false;
        }
        Optional optScope = methodCall.getScope();
        if (!this.scopeHasRequiredType((Optional<Expression>)optScope, String.class)) {
            return false;
        }
        Expression scope = (Expression)optScope.get();
        boolean localTransformed = false;
        MethodCallExpr replacement = new MethodCallExpr(scope, METHOD_TO_STRING);
        LOGGER.info("Turning {} into {}", (Object)node, (Object)replacement);
        if (node.replace((Node)scope)) {
            localTransformed = true;
        }
        return localTransformed;
    }
}

