/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.nodeTypes.NodeWithType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import eu.solven.cleanthat.engine.java.refactorer.AJavaParserMutator;
import eu.solven.cleanthat.engine.java.refactorer.meta.IMutator;
import eu.solven.pepper.logging.PepperLogHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnnecessaryFullyQualifiedName
extends AJavaParserMutator
implements IMutator {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnnecessaryFullyQualifiedName.class);

    @Override
    public String minimalJavaVersion() {
        return "11";
    }

    @Override
    public Optional<String> getPmdId() {
        return Optional.of("UnnecessaryFullyQualifiedName");
    }

    @Override
    public String pmdUrl() {
        return "https://pmd.github.io/latest/pmd_rules_java_codestyle.html#unnecessaryfullyqualifiedname";
    }

    @Override
    protected boolean processNotRecursively(Node node) {
        List<ImportDeclaration> imports;
        Optional<ImportDeclaration> optMatchingImport;
        LOGGER.debug("{}", PepperLogHelper.getObjectAndClass((Object)node));
        if (!(node instanceof NodeWithType)) {
            return false;
        }
        NodeWithType nodeWithType = (NodeWithType)node;
        Type nodeType = nodeWithType.getType();
        boolean doSimplifyType = nodeType.asString().startsWith("java.lang") ? true : !(optMatchingImport = this.searchMatchingImport(imports = this.getImports(node), nodeWithType.getType())).isEmpty();
        if (!doSimplifyType) {
            return false;
        }
        int nodeTypeLastDot = nodeType.asString().lastIndexOf(46);
        if (nodeTypeLastDot < 0) {
            LOGGER.debug("Import without a '.' ?");
            return false;
        }
        String newType = nodeWithType.getType().asString().substring(nodeTypeLastDot + 1);
        nodeWithType.setType(newType);
        return true;
    }

    private List<ImportDeclaration> getImports(Node node) {
        Node root = node;
        while (root.getParentNode().isPresent()) {
            root = (Node)root.getParentNode().get();
        }
        ImportVisitorAdapter visitor = new ImportVisitorAdapter();
        root.accept((VoidVisitor)visitor, null);
        List<ImportDeclaration> imports = visitor.getImports();
        return imports;
    }

    private Optional<ImportDeclaration> searchMatchingImport(List<ImportDeclaration> imports, Type type) {
        return imports.stream().filter(i -> {
            String importedTypeOrPackage = i.getNameAsString();
            String nodeTypeMayDiamond = type.asString();
            if (nodeTypeMayDiamond.indexOf(60) >= 0) {
                nodeTypeMayDiamond = nodeTypeMayDiamond.substring(0, nodeTypeMayDiamond.indexOf(60));
            }
            return importedTypeOrPackage.equals(nodeTypeMayDiamond);
        }).findFirst();
    }

    public static class ImportVisitorAdapter
    extends VoidVisitorAdapter<Object> {
        final List<ImportDeclaration> imports = new ArrayList<ImportDeclaration>();

        public void visit(ImportDeclaration n, Object arg) {
            super.visit(n, arg);
            this.imports.add(n);
        }

        public List<ImportDeclaration> getImports() {
            return this.imports;
        }
    }
}

