/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.CharLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import eu.solven.cleanthat.engine.java.refactorer.AJavaParserMutator;
import eu.solven.cleanthat.engine.java.refactorer.meta.IMutator;
import eu.solven.pepper.logging.PepperLogHelper;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UseIndexOfChar
extends AJavaParserMutator
implements IMutator {
    private static final Logger LOGGER = LoggerFactory.getLogger(UseIndexOfChar.class);

    @Override
    public String minimalJavaVersion() {
        return "1";
    }

    @Override
    public boolean isProductionReady() {
        return true;
    }

    @Override
    public String pmdUrl() {
        return "https://pmd.github.io/latest/pmd_rules_java_performance.html#useindexofchar";
    }

    @Override
    public Optional<String> getPmdId() {
        return Optional.of("UseIndexOfChar");
    }

    @Override
    protected boolean processNotRecursively(Node node) {
        LOGGER.debug("{}", PepperLogHelper.getObjectAndClass((Object)node));
        if (!(node instanceof StringLiteralExpr)) {
            return false;
        }
        StringLiteralExpr stringLiteralExpr = (StringLiteralExpr)node;
        String stringLiteralExprValue = stringLiteralExpr.getValue();
        if (stringLiteralExprValue.length() != 1) {
            return false;
        }
        if (!stringLiteralExpr.getParentNode().isPresent()) {
            return false;
        }
        Node parentNode = (Node)stringLiteralExpr.getParentNode().get();
        if (!(parentNode instanceof MethodCallExpr)) {
            return false;
        }
        MethodCallExpr parentMethodCall = (MethodCallExpr)parentNode;
        if (!"indexOf".equals(parentMethodCall.getNameAsString())) {
            return false;
        }
        if (!this.scopeHasRequiredType((Optional<Expression>)parentMethodCall.getScope(), String.class)) {
            return false;
        }
        return node.replace((Node)new CharLiteralExpr(stringLiteralExprValue.charAt(0)));
    }
}

