/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import eu.solven.cleanthat.engine.java.refactorer.AJavaParserMutator;
import eu.solven.cleanthat.engine.java.refactorer.meta.IMutator;
import eu.solven.pepper.logging.PepperLogHelper;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UseIsEmptyOnCollections
extends AJavaParserMutator
implements IMutator {
    private static final Logger LOGGER = LoggerFactory.getLogger(UseIsEmptyOnCollections.class);
    private static final IntegerLiteralExpr ZERO_EXPR = new IntegerLiteralExpr("0");

    @Override
    public boolean isProductionReady() {
        return true;
    }

    @Override
    public String minimalJavaVersion() {
        return "1.6";
    }

    @Override
    public String pmdUrl() {
        return "https://pmd.github.io/latest/pmd_rules_java_bestpractices.html#usecollectionisempty";
    }

    @Override
    public Optional<String> getPmdId() {
        return Optional.of("UseCollectionIsEmpty");
    }

    @Override
    protected boolean processNotRecursively(Node node) {
        boolean localTransformed;
        LOGGER.debug("{}", PepperLogHelper.getObjectAndClass((Object)node));
        if (!(node instanceof BinaryExpr)) {
            return false;
        }
        BinaryExpr binaryExpr = (BinaryExpr)node;
        if (!BinaryExpr.Operator.EQUALS.equals((Object)binaryExpr.getOperator())) {
            return false;
        }
        Optional<Object> checkmeForIsEmpty = ZERO_EXPR.equals((Object)binaryExpr.getRight()) && binaryExpr.getLeft() instanceof MethodCallExpr ? Optional.of((MethodCallExpr)binaryExpr.getLeft()) : (ZERO_EXPR.equals((Object)binaryExpr.getLeft()) && binaryExpr.getRight() instanceof MethodCallExpr ? Optional.of((MethodCallExpr)binaryExpr.getRight()) : Optional.empty());
        if (checkmeForIsEmpty.isEmpty()) {
            return false;
        }
        Optional optLengthScope = ((MethodCallExpr)checkmeForIsEmpty.get()).getScope();
        if (optLengthScope.isEmpty()) {
            return false;
        }
        String calledMethodName = ((MethodCallExpr)checkmeForIsEmpty.get()).getNameAsString();
        if (!"size".equals(calledMethodName) && !"length".equals(calledMethodName)) {
            LOGGER.debug("Not calling .size() nor .length()");
            return false;
        }
        Expression lengthScope = (Expression)optLengthScope.get();
        Optional<ResolvedType> type = this.optResolvedType(lengthScope);
        return type.isPresent() && (localTransformed = this.checkTypeAndProcess(node, lengthScope, type.get()));
    }

    private boolean checkTypeAndProcess(Node node, Expression lengthScope, ResolvedType type) {
        boolean transformed;
        if (type.isReferenceType()) {
            LOGGER.info("scope={} type={}", (Object)lengthScope, (Object)type);
            boolean doIt = false;
            ResolvedReferenceType referenceType = type.asReferenceType();
            if (referenceType.getQualifiedName().equals(Collection.class.getName()) || referenceType.getQualifiedName().equals(Map.class.getName()) || referenceType.getQualifiedName().equals(String.class.getName())) {
                doIt = true;
            } else {
                try {
                    Class<?> clazz = Class.forName(referenceType.getQualifiedName());
                    if (Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz) || String.class.isAssignableFrom(clazz)) {
                        doIt = true;
                    }
                }
                catch (ClassNotFoundException | RuntimeException e) {
                    LOGGER.debug("This class is not available. Can not confirm it is a Colletion/Map/String");
                }
            }
            transformed = doIt ? node.replace((Node)new MethodCallExpr(lengthScope, "isEmpty")) : false;
        } else {
            transformed = false;
        }
        return transformed;
    }
}

