/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.helpers;

import java.util.Optional;
import java.util.function.Consumer;

public class OptionalOrRejection<T> {
    final boolean rejected;
    final Optional<T> optResult;

    protected OptionalOrRejection(boolean rejected, Optional<T> optResult) {
        this.rejected = rejected;
        this.optResult = optResult;
    }

    public boolean isRejected() {
        return this.rejected;
    }

    public Optional<T> getOptional() {
        return this.optResult;
    }

    public static <T> OptionalOrRejection<T> reject() {
        return new OptionalOrRejection(true, Optional.empty());
    }

    public static <T> OptionalOrRejection<T> empty() {
        return new OptionalOrRejection(false, Optional.empty());
    }

    public static <T> OptionalOrRejection<T> present(T result) {
        return new OptionalOrRejection<T>(false, Optional.of(result));
    }

    public static <T> OptionalOrRejection<T> optional(Optional<T> optional) {
        return new OptionalOrRejection<T>(false, optional);
    }

    public void ifPresent(Consumer<T> consumer) {
        this.optResult.ifPresent(consumer);
    }
}

