/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.helpers;

import com.github.javaparser.ast.type.Type;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.model.SymbolReference;
import com.github.javaparser.resolution.model.typesystem.LazyType;
import com.github.javaparser.resolution.model.typesystem.ReferenceTypeImpl;
import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.resolution.typesolvers.ReflectionTypeSolver;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserNodeMutator;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolvedTypeHelpers {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResolvedTypeHelpers.class);

    protected ResolvedTypeHelpers() {
    }

    public static boolean areSameType(ResolvedType left, ResolvedType right) {
        if (left instanceof LazyType || right instanceof LazyType) {
            return left.describe().equals(right.describe());
        }
        return left.equals(right);
    }

    public static Optional<ResolvedType> optResolvedType(Type type) {
        try {
            return Optional.of(type.resolve());
        }
        catch (RuntimeException e) {
            try {
                ResolvedType secondTryType = type.resolve();
                AJavaparserNodeMutator.logJavaParserIssue(type, e, "https://github.com/javaparser/javaparser/issues/3939");
                return Optional.of(secondTryType);
            }
            catch (RuntimeException ee) {
                LOGGER.debug("Issue with JavaParser over {}", (Object)type, (Object)ee);
                return Optional.empty();
            }
        }
        catch (NoClassDefFoundError e) {
            AJavaparserNodeMutator.logJavaParserIssue(type, e, "https://github.com/javaparser/javaparser/issues/3504");
            return Optional.empty();
        }
    }

    public static boolean isAssignableBy(ReferenceTypeImpl referenceTypeImpl, ResolvedType resolvedType) {
        try {
            return referenceTypeImpl.isAssignableBy(resolvedType);
        }
        catch (UnsolvedSymbolException e) {
            LOGGER.debug("Unresolved: `{}` .isAssignableBy `{}`", new Object[]{referenceTypeImpl, resolvedType, e});
            return false;
        }
    }

    public static boolean isAssignableBy(String qualifiedClassName, ResolvedType resolvedType) {
        ReflectionTypeSolver typeSolver = new ReflectionTypeSolver(false);
        SymbolReference optType = typeSolver.tryToSolveType(qualifiedClassName);
        if (!optType.isSolved()) {
            return false;
        }
        ReferenceTypeImpl referenceTypeImpl = new ReferenceTypeImpl((ResolvedReferenceTypeDeclaration)optType.getCorrespondingDeclaration());
        return ResolvedTypeHelpers.isAssignableBy(referenceTypeImpl, resolvedType);
    }

    public static boolean typeIsAssignable(Optional<ResolvedType> optType, String requiredType) {
        if (optType.isEmpty()) {
            return false;
        }
        ResolvedType type = optType.get();
        boolean isCorrectClass = false;
        if (type.isConstraint()) {
            type = type.asConstraintType().getBound();
        }
        if (ResolvedTypeHelpers.isAssignableBy(requiredType, type)) {
            isCorrectClass = true;
        } else if (type.isPrimitive() && type.asPrimitive().describe().equals(requiredType)) {
            isCorrectClass = true;
        }
        return isCorrectClass;
    }
}

