/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.CharLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.UnaryExpr;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserExprMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.helpers.MethodCallExprHelpers;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

@Deprecated(since="Dropped with PMD 7.0")
public class SimplifyStartsWith
extends AJavaparserExprMutator {
    public String minimalJavaVersion() {
        return "1.6";
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"String");
    }

    public Optional<String> getPmdId() {
        return Optional.of("SimplifyStartsWith");
    }

    public String pmdUrl() {
        return "https://pmd.github.io/latest/pmd_rules_java_performance.html#simplifystartswith";
    }

    public Set<String> getLegacyIds() {
        return Set.of("StringStartsWithChar");
    }

    public boolean isDraft() {
        return false;
    }

    @Override
    protected boolean processExpression(NodeAndSymbolSolver<Expression> expr) {
        boolean isAndNotEmptyElseOrEmpty;
        if (!expr.getNode().isBinaryExpr()) {
            return false;
        }
        BinaryExpr binaryExpr = expr.getNode().asBinaryExpr();
        BinaryExpr.Operator operator = binaryExpr.getOperator();
        if (operator == BinaryExpr.Operator.AND) {
            isAndNotEmptyElseOrEmpty = true;
        } else if (operator == BinaryExpr.Operator.OR) {
            isAndNotEmptyElseOrEmpty = false;
        } else {
            return false;
        }
        Optional<MethodCallExpr> optStartsWith = this.findStartsWith(expr, binaryExpr.getLeft(), binaryExpr.getRight());
        Optional<MethodCallExpr> optIsEmpty = this.findIsEmpty(expr, binaryExpr.getLeft(), binaryExpr.getRight(), isAndNotEmptyElseOrEmpty);
        if (optStartsWith.isEmpty() || optIsEmpty.isEmpty()) {
            return false;
        }
        MethodCallExpr startsWithMethodCall = optStartsWith.get();
        MethodCallExpr isEmptyMethodCall = optIsEmpty.get();
        Object callIsEmptyExpr = isAndNotEmptyElseOrEmpty ? (Expression)isEmptyMethodCall.getParentNode().orElseThrow() : isEmptyMethodCall;
        Optional optRightScope = isEmptyMethodCall.getScope();
        Optional optLeftScope = startsWithMethodCall.getScope();
        if (optRightScope.isEmpty() || optLeftScope.isEmpty()) {
            return false;
        }
        if (!this.sameScope((Expression)optLeftScope.get(), (Expression)optRightScope.get())) {
            return false;
        }
        binaryExpr.setLeft((Expression)callIsEmptyExpr);
        binaryExpr.setRight((Expression)startsWithMethodCall);
        Character singleChar = this.optCallStartsWithSingleCharString(expr.editNode(startsWithMethodCall)).get();
        return this.tryReplace((Node)startsWithMethodCall, (Node)this.makeCharAtEqualsTo(optLeftScope, singleChar));
    }

    private Optional<MethodCallExpr> findIsEmpty(NodeAndSymbolSolver<?> context, Expression left, Expression right, boolean isAndNotEmptyElseOrEmpty) {
        return Stream.of(left, right).flatMap(expr -> this.findIsEmpty(context, (Expression)expr, isAndNotEmptyElseOrEmpty).stream()).findFirst();
    }

    private Optional<MethodCallExpr> findIsEmpty(NodeAndSymbolSolver<?> context, Expression left, boolean isAndNotEmptyElseOrEmpty) {
        if (isAndNotEmptyElseOrEmpty) {
            if (!left.isUnaryExpr()) {
                return Optional.empty();
            }
            if (left.asUnaryExpr().getOperator() != UnaryExpr.Operator.LOGICAL_COMPLEMENT) {
                return Optional.empty();
            }
            left = left.asUnaryExpr().getExpression();
        }
        if (left.isMethodCallExpr() && this.isCallIsEmptyString(context.editNode(left.asMethodCallExpr()))) {
            return Optional.of(left.asMethodCallExpr());
        }
        return Optional.empty();
    }

    private Optional<MethodCallExpr> findStartsWith(NodeAndSymbolSolver<?> context, Expression left, Expression right) {
        if (left.isMethodCallExpr() && this.optCallStartsWithSingleCharString(context.editNode(left.asMethodCallExpr())).isPresent()) {
            return Optional.of(left.asMethodCallExpr());
        }
        if (right.isMethodCallExpr() && this.optCallStartsWithSingleCharString(context.editNode(right.asMethodCallExpr())).isPresent()) {
            return Optional.of(right.asMethodCallExpr());
        }
        return Optional.empty();
    }

    private BinaryExpr makeCharAtEqualsTo(Optional<Expression> optLeftScope, Character singleChar) {
        return new BinaryExpr((Expression)new MethodCallExpr(optLeftScope.get(), "charAt", new NodeList((Node[])new Expression[]{new IntegerLiteralExpr("0")})), (Expression)new CharLiteralExpr(singleChar.charValue()), BinaryExpr.Operator.EQUALS);
    }

    private boolean sameScope(Expression left, Expression right) {
        return left.isNameExpr() && right.isNameExpr() && left.asNameExpr().getNameAsString().equals(right.asNameExpr().getNameAsString());
    }

    private boolean isCallIsEmptyString(NodeAndSymbolSolver<MethodCallExpr> left) {
        return "isEmpty".equals(left.getNode().getNameAsString()) && MethodCallExprHelpers.scopeHasRequiredType(left.editNode(left.getNode().getScope()), String.class);
    }

    private Optional<Character> optCallStartsWithSingleCharString(NodeAndSymbolSolver<MethodCallExpr> expr) {
        boolean hasSingleCharString;
        MethodCallExpr methodCall = expr.getNode();
        if (!"startsWith".equals(expr.getNode().getNameAsString()) || !MethodCallExprHelpers.scopeHasRequiredType(expr.editNode(methodCall.getScope()), String.class)) {
            return Optional.empty();
        }
        NodeList arguments = methodCall.getArguments();
        if (arguments.size() != 1) {
            return Optional.empty();
        }
        Expression singleArgument = methodCall.getArgument(0);
        boolean bl = hasSingleCharString = singleArgument.isStringLiteralExpr() && singleArgument.asStringLiteralExpr().getValue().length() == 1;
        if (hasSingleCharString) {
            return Optional.of(Character.valueOf(singleArgument.asStringLiteralExpr().getValue().charAt(0)));
        }
        return Optional.empty();
    }
}

