/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserExprMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.helpers.ImportDeclarationHelpers;
import eu.solven.cleanthat.engine.java.refactorer.helpers.MethodCallExprHelpers;
import eu.solven.cleanthat.engine.java.refactorer.meta.ApplyAfterMe;
import eu.solven.cleanthat.engine.java.refactorer.mutators.OptionalWrappedIfToFilter;
import eu.solven.cleanthat.engine.java.refactorer.mutators.OptionalWrappedVariableToMap;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.Set;

@ApplyAfterMe(value={OptionalWrappedIfToFilter.class, OptionalWrappedVariableToMap.class})
public class UsePredefinedStandardCharset
extends AJavaparserExprMutator {
    public String minimalJavaVersion() {
        return "1.7";
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"NIO");
    }

    public Optional<String> getSonarId() {
        return Optional.of("RPSEC-4719");
    }

    public Optional<String> getJSparrowId() {
        return Optional.of("UsePredefinedStandardCharset");
    }

    public String jSparrowUrl() {
        return "https://jsparrow.github.io/rules/use-predefined-standard-charset.html";
    }

    @Override
    protected boolean processExpression(NodeAndSymbolSolver<Expression> expr) {
        if (!expr.getNode().isMethodCallExpr()) {
            return false;
        }
        MethodCallExpr methodCallExpr = expr.getNode().asMethodCallExpr();
        if (!"forName".equals(methodCallExpr.getNameAsString())) {
            return false;
        }
        if (methodCallExpr.getArguments().size() != 1) {
            return false;
        }
        if (!MethodCallExprHelpers.scopeHasRequiredType(expr.editNode(methodCallExpr.getScope()), Charset.class)) {
            return false;
        }
        Expression singleArgument = methodCallExpr.getArgument(0);
        Optional<String> optFieldName = this.findCharset(singleArgument);
        if (optFieldName.isEmpty()) {
            return false;
        }
        NameExpr className = ImportDeclarationHelpers.nameOrQualifiedName(expr, StandardCharsets.class);
        return this.tryReplace((Node)methodCallExpr, (Node)new FieldAccessExpr((Expression)className, optFieldName.get()));
    }

    private Optional<String> findCharset(Expression singleArgument) {
        if (new StringLiteralExpr("UTF-8").equals((Object)singleArgument)) {
            return Optional.of("UTF_8");
        }
        if (new StringLiteralExpr("UTF-16").equals((Object)singleArgument)) {
            return Optional.of("UTF_16");
        }
        if (new StringLiteralExpr("UTF-16BE").equals((Object)singleArgument)) {
            return Optional.of("UTF_16BE");
        }
        if (new StringLiteralExpr("UTF-16LE").equals((Object)singleArgument)) {
            return Optional.of("UTF_16LE");
        }
        if (new StringLiteralExpr("US-ASCII").equals((Object)singleArgument)) {
            return Optional.of("US_ASCII");
        }
        if (new StringLiteralExpr("ISO-8859-1").equals((Object)singleArgument)) {
            return Optional.of("ISO_8859_1");
        }
        return Optional.empty();
    }
}

