/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer;

import eu.solven.cleanthat.engine.java.refactorer.AAstRefactorer;
import eu.solven.cleanthat.engine.java.refactorer.meta.IWalkingMutator;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AstRefactorerInstance<AST, P, R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AstRefactorerInstance.class);
    final AAstRefactorer<AST, P, R, ? extends IWalkingMutator<AST, R>> astRefactorer;
    final P parser;
    final IWalkingMutator<AST, R> mutator;
    final AtomicReference<AST> refCompilationUnit;
    final AtomicBoolean firstMutator;
    final AtomicBoolean inputIsBroken;

    AstRefactorerInstance(AAstRefactorer<AST, P, R, ? extends IWalkingMutator<AST, R>> astRefactorer, P parser, IWalkingMutator<AST, R> ct, AtomicReference<AST> refCompilationUnit, AtomicBoolean firstMutator, AtomicBoolean inputIsBroken) {
        this.astRefactorer = astRefactorer;
        this.mutator = ct;
        this.parser = parser;
        this.refCompilationUnit = refCompilationUnit;
        this.firstMutator = firstMutator;
        this.inputIsBroken = inputIsBroken;
    }

    public boolean applyOneMutator(AtomicReference<String> refCleanCode, AtomicReference<AST> refCompilationUnit, AtomicBoolean firstMutator, AtomicBoolean inputIsBroken, Path path) {
        if (inputIsBroken.get()) {
            LOGGER.trace("We skip {} as the input is broken", this.mutator);
            return false;
        }
        LOGGER.debug("Applying {}", this.mutator);
        this.parseCompilationUnit(refCompilationUnit, firstMutator, inputIsBroken, refCleanCode.get(), path);
        return this.applyMutator(refCleanCode, refCompilationUnit, path, this.mutator);
    }

    private boolean applyMutator(AtomicReference<String> refCleanCode, AtomicReference<AST> optCompilationUnit, Path path, IWalkingMutator<AST, R> mutator) {
        boolean appliedWithChange;
        Optional<R> walkNodeResult;
        AST compilationUnit = optCompilationUnit.get();
        if (compilationUnit == null) {
            return false;
        }
        try {
            walkNodeResult = mutator.walkAst(compilationUnit);
        }
        catch (RuntimeException | StackOverflowError e) {
            throw new IllegalArgumentException("Issue with mutator: " + mutator, e);
        }
        if (walkNodeResult.isPresent()) {
            LOGGER.debug("IMutator {} linted succesfully {}", (Object)mutator.getClass().getSimpleName(), (Object)path);
            String resultAsString = this.astRefactorer.toString(walkNodeResult.get());
            if (this.astRefactorer.isValidResultString(this.parser, resultAsString)) {
                if (refCleanCode.get().equals(resultAsString)) {
                    appliedWithChange = false;
                } else {
                    refCleanCode.set(resultAsString);
                    appliedWithChange = true;
                }
            } else {
                LOGGER.warn("{} generated invalid code over {}", mutator, (Object)path);
                appliedWithChange = false;
            }
            optCompilationUnit.set(null);
        } else {
            appliedWithChange = false;
        }
        return appliedWithChange;
    }

    private void parseCompilationUnit(AtomicReference<AST> optCompilationUnit, AtomicBoolean firstMutator, AtomicBoolean inputIsBroken, String refCleanCode, Path path) {
        if (optCompilationUnit.get() == null) {
            try {
                String sourceCode = refCleanCode;
                Optional<AST> tryCompilationUnit = this.astRefactorer.parseSourceCode(this.parser, sourceCode);
                if (tryCompilationUnit.isEmpty()) {
                    LOGGER.warn("Not able to parse path='{}' with {}", (Object)path, this.parser);
                    if (firstMutator.get()) {
                        LOGGER.info("We mark path='{}' as not parseable by any mutator", (Object)path);
                        inputIsBroken.set(true);
                    }
                    return;
                }
                optCompilationUnit.set(tryCompilationUnit.get());
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("Issue parsing the code", e);
            }
        }
        firstMutator.set(false);
    }
}

