/*
 * Decompiled with CFR 0.152.
 */
package imgui.app;

import imgui.ImGui;
import imgui.app.Color;
import imgui.app.Configuration;
import imgui.gl3.ImGuiImplGl3;
import imgui.glfw.ImGuiImplGlfw;
import java.io.PrintStream;
import java.nio.IntBuffer;
import java.util.Objects;
import org.lwjgl.glfw.Callbacks;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.glfw.GLFWWindowSizeCallback;
import org.lwjgl.glfw.GLFWWindowSizeCallbackI;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL32;
import org.lwjgl.system.MemoryStack;

public abstract class Window {
    protected ImGuiImplGlfw imGuiGlfw = new ImGuiImplGlfw();
    protected ImGuiImplGl3 imGuiGl3 = new ImGuiImplGl3();
    private String glslVersion = null;
    protected long handle;
    protected final Color colorBg = new Color(0.5f, 0.5f, 0.5f, 1.0f);

    protected void init(Configuration config) {
        this.initWindow(config);
        this.initImGui(config);
        this.imGuiGlfw.init(this.handle, true);
        this.imGuiGl3.init(this.glslVersion);
    }

    protected void dispose() {
        this.imGuiGl3.shutdown();
        this.imGuiGlfw.shutdown();
        this.disposeImGui();
        this.disposeWindow();
    }

    protected void initWindow(Configuration config) {
        GLFWErrorCallback.createPrint((PrintStream)System.err).set();
        if (!GLFW.glfwInit()) {
            throw new IllegalStateException("Unable to initialize GLFW");
        }
        this.decideGlGlslVersions();
        GLFW.glfwWindowHint((int)131076, (int)0);
        this.handle = GLFW.glfwCreateWindow((int)config.getWidth(), (int)config.getHeight(), (CharSequence)config.getTitle(), (long)0L, (long)0L);
        if (this.handle == 0L) {
            throw new RuntimeException("Failed to create the GLFW window");
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer pWidth = stack.mallocInt(1);
            IntBuffer pHeight = stack.mallocInt(1);
            GLFW.glfwGetWindowSize((long)this.handle, (IntBuffer)pWidth, (IntBuffer)pHeight);
            GLFWVidMode vidmode = Objects.requireNonNull(GLFW.glfwGetVideoMode((long)GLFW.glfwGetPrimaryMonitor()));
            GLFW.glfwSetWindowPos((long)this.handle, (int)((vidmode.width() - pWidth.get(0)) / 2), (int)((vidmode.height() - pHeight.get(0)) / 2));
        }
        GLFW.glfwMakeContextCurrent((long)this.handle);
        GL.createCapabilities();
        GLFW.glfwSwapInterval((int)1);
        if (config.isFullScreen()) {
            GLFW.glfwMaximizeWindow((long)this.handle);
        } else {
            GLFW.glfwShowWindow((long)this.handle);
        }
        this.clearBuffer();
        this.renderBuffer();
        GLFW.glfwSetWindowSizeCallback((long)this.handle, (GLFWWindowSizeCallbackI)new GLFWWindowSizeCallback(){

            public void invoke(long window, int width, int height) {
                Window.this.runFrame();
            }
        });
    }

    private void decideGlGlslVersions() {
        boolean isMac = System.getProperty("os.name").toLowerCase().contains("mac");
        if (isMac) {
            this.glslVersion = "#version 150";
            GLFW.glfwWindowHint((int)139266, (int)3);
            GLFW.glfwWindowHint((int)139267, (int)2);
            GLFW.glfwWindowHint((int)139272, (int)204801);
            GLFW.glfwWindowHint((int)139270, (int)1);
        } else {
            this.glslVersion = "#version 130";
            GLFW.glfwWindowHint((int)139266, (int)3);
            GLFW.glfwWindowHint((int)139267, (int)0);
        }
    }

    protected void initImGui(Configuration config) {
        ImGui.createContext();
    }

    protected void preProcess() {
    }

    protected void postProcess() {
    }

    protected void run() {
        while (!GLFW.glfwWindowShouldClose((long)this.handle)) {
            this.runFrame();
        }
    }

    protected void runFrame() {
        this.startFrame();
        this.preProcess();
        this.process();
        this.postProcess();
        this.endFrame();
    }

    public abstract void process();

    private void clearBuffer() {
        GL32.glClearColor((float)this.colorBg.getRed(), (float)this.colorBg.getGreen(), (float)this.colorBg.getBlue(), (float)this.colorBg.getAlpha());
        GL32.glClear((int)16640);
    }

    protected void startFrame() {
        this.clearBuffer();
        this.imGuiGl3.newFrame();
        this.imGuiGlfw.newFrame();
        ImGui.newFrame();
    }

    protected void endFrame() {
        ImGui.render();
        this.imGuiGl3.renderDrawData(ImGui.getDrawData());
        if (ImGui.getIO().hasConfigFlags(1024)) {
            long backupCurrentContext = GLFW.glfwGetCurrentContext();
            ImGui.updatePlatformWindows();
            ImGui.renderPlatformWindowsDefault();
            GLFW.glfwMakeContextCurrent((long)backupCurrentContext);
        }
        this.renderBuffer();
    }

    private void renderBuffer() {
        GLFW.glfwSwapBuffers((long)this.handle);
        GLFW.glfwPollEvents();
    }

    protected void disposeImGui() {
        ImGui.destroyContext();
    }

    protected void disposeWindow() {
        Callbacks.glfwFreeCallbacks((long)this.handle);
        GLFW.glfwDestroyWindow((long)this.handle);
        GLFW.glfwTerminate();
        Objects.requireNonNull(GLFW.glfwSetErrorCallback(null)).free();
    }

    public final long getHandle() {
        return this.handle;
    }

    public final Color getColorBg() {
        return this.colorBg;
    }
}

