/*
 * Decompiled with CFR 0.152.
 */
package io.github.spark_redshift_community.spark.redshift;

import io.github.spark_redshift_community.spark.redshift.RedshiftInputFormat$;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Uf!B\u0001\u0003\u0001\ta!\u0001\u0006*fIND\u0017N\u001a;SK\u000e|'\u000f\u001a*fC\u0012,'O\u0003\u0002\u0004\t\u0005A!/\u001a3tQ&4GO\u0003\u0002\u0006\r\u0005)1\u000f]1sW*\u0011q\u0001C\u0001\u0019gB\f'o[0sK\u0012\u001c\b.\u001b4u?\u000e|W.\\;oSRL(BA\u0005\u000b\u0003\u00199\u0017\u000e\u001e5vE*\t1\"\u0001\u0002j_N\u0011\u0001!\u0004\t\u0005\u001d]I\u0012%D\u0001\u0010\u0015\t\u0001\u0012#A\u0005nCB\u0014X\rZ;dK*\u0011!cE\u0001\u0007Q\u0006$wn\u001c9\u000b\u0005Q)\u0012AB1qC\u000eDWMC\u0001\u0017\u0003\ry'oZ\u0005\u00031=\u0011ABU3d_J$'+Z1eKJ\u0004\"AG\u0010\u000e\u0003mQ!\u0001H\u000f\u0002\t1\fgn\u001a\u0006\u0002=\u0005!!.\u0019<b\u0013\t\u00013D\u0001\u0003M_:<\u0007c\u0001\u0012&O5\t1EC\u0001%\u0003\u0015\u00198-\u00197b\u0013\t13EA\u0003BeJ\f\u0017\u0010\u0005\u0002)W9\u0011!%K\u0005\u0003U\r\na\u0001\u0015:fI\u00164\u0017B\u0001\u0017.\u0005\u0019\u0019FO]5oO*\u0011!f\t\u0005\u0006_\u0001!\t!M\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\t!\u0007\u0005\u00024\u00015\t!\u0001C\u00056\u0001\u0001\u0007\t\u0019!C\u0005m\u00051!/Z1eKJ,\u0012a\u000e\t\u0003qij\u0011!\u000f\u0006\u0003\u0017uI!aO\u001d\u0003'\t+hMZ3sK\u0012Le\u000e];u'R\u0014X-Y7\t\u0013u\u0002\u0001\u0019!a\u0001\n\u0013q\u0014A\u0003:fC\u0012,'o\u0018\u0013fcR\u0011qH\u0011\t\u0003E\u0001K!!Q\u0012\u0003\tUs\u0017\u000e\u001e\u0005\b\u0007r\n\t\u00111\u00018\u0003\rAH%\r\u0005\u0007\u000b\u0002\u0001\u000b\u0015B\u001c\u0002\u000fI,\u0017\rZ3sA!Iq\t\u0001a\u0001\u0002\u0004%I\u0001S\u0001\u0004W\u0016LX#A\r\t\u0013)\u0003\u0001\u0019!a\u0001\n\u0013Y\u0015aB6fs~#S-\u001d\u000b\u0003\u007f1CqaQ%\u0002\u0002\u0003\u0007\u0011\u0004\u0003\u0004O\u0001\u0001\u0006K!G\u0001\u0005W\u0016L\b\u0005C\u0005Q\u0001\u0001\u0007\t\u0019!C\u0005#\u0006)a/\u00197vKV\t\u0011\u0005C\u0005T\u0001\u0001\u0007\t\u0019!C\u0005)\u0006Ia/\u00197vK~#S-\u001d\u000b\u0003\u007fUCqa\u0011*\u0002\u0002\u0003\u0007\u0011\u0005\u0003\u0004X\u0001\u0001\u0006K!I\u0001\u0007m\u0006dW/\u001a\u0011\t\u0013e\u0003\u0001\u0019!a\u0001\n\u0013Q\u0016!B:uCJ$X#A.\u0011\u0005\tb\u0016B\u0001\u0011$\u0011%q\u0006\u00011AA\u0002\u0013%q,A\u0005ti\u0006\u0014Ho\u0018\u0013fcR\u0011q\b\u0019\u0005\b\u0007v\u000b\t\u00111\u0001\\\u0011\u0019\u0011\u0007\u0001)Q\u00057\u000611\u000f^1si\u0002B\u0011\u0002\u001a\u0001A\u0002\u0003\u0007I\u0011\u0002.\u0002\u0007\u0015tG\rC\u0005g\u0001\u0001\u0007\t\u0019!C\u0005O\u00069QM\u001c3`I\u0015\fHCA i\u0011\u001d\u0019U-!AA\u0002mCaA\u001b\u0001!B\u0013Y\u0016\u0001B3oI\u0002B\u0011\u0002\u001c\u0001A\u0002\u0003\u0007I\u0011\u0002.\u0002\u0007\r,(\u000fC\u0005o\u0001\u0001\u0007\t\u0019!C\u0005_\u000691-\u001e:`I\u0015\fHCA q\u0011\u001d\u0019U.!AA\u0002mCaA\u001d\u0001!B\u0013Y\u0016\u0001B2ve\u0002Bq\u0001\u001e\u0001A\u0002\u0013%Q/A\u0002f_\u001a,\u0012A\u001e\t\u0003E]L!\u0001_\u0012\u0003\u000f\t{w\u000e\\3b]\"9!\u0010\u0001a\u0001\n\u0013Y\u0018aB3pM~#S-\u001d\u000b\u0003\u007fqDqaQ=\u0002\u0002\u0003\u0007a\u000f\u0003\u0004\u007f\u0001\u0001\u0006KA^\u0001\u0005K>4\u0007\u0005C\u0006\u0002\u0002\u0001\u0001\r\u00111A\u0005\n\u0005\r\u0011!\u00033fY&l\u0017\u000e^3s+\t\t)\u0001E\u0002#\u0003\u000fI1!!\u0003$\u0005\u0011\u0011\u0015\u0010^3\t\u0017\u00055\u0001\u00011AA\u0002\u0013%\u0011qB\u0001\u000eI\u0016d\u0017.\\5uKJ|F%Z9\u0015\u0007}\n\t\u0002C\u0005D\u0003\u0017\t\t\u00111\u0001\u0002\u0006!A\u0011Q\u0003\u0001!B\u0013\t)!\u0001\u0006eK2LW.\u001b;fe\u0002B\u0001\"!\u0007\u0001A\u00035\u0011QA\u0001\u000bKN\u001c\u0017\r]3DQ\u0006\u0014\b\u0006BA\f\u0003;\u00012AIA\u0010\u0013\r\t\tc\t\u0002\u0007S:d\u0017N\\3\t\u0011\u0005\u0015\u0002\u0001)A\u0007\u0003\u000b\t\u0001\u0002\\5oK\u001a+W\r\u001a\u0015\u0005\u0003G\ti\u0002\u0003\u0005\u0002,\u0001\u0001\u000bQBA\u0003\u00039\u0019\u0017M\u001d:jC\u001e,'+\u001a;ve:DC!!\u000b\u0002\u001e!A\u0011\u0011\u0007\u0001!\u0002\u001b\t\u0019$A\teK\u001a\fW\u000f\u001c;Ck\u001a4WM]*ju\u0016|!!!\u000e\u001e\u0007A\u0001\u0001\u0001\u000b\u0003\u00020\u0005u\u0001\u0002CA\u001e\u0001\u0001\u0006I!!\u0010\u0002\u000b\rD\u0017M]:\u0011\r\u0005}\u0012\u0011JA\u0003\u001b\t\t\tE\u0003\u0003\u0002D\u0005\u0015\u0013aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u000f\u001a\u0013AC2pY2,7\r^5p]&!\u00111JA!\u0005-\t%O]1z\u0005V4g-\u001a:\t\u000f\u0005=\u0003\u0001\"\u0011\u0002R\u0005Q\u0011N\\5uS\u0006d\u0017N_3\u0015\u000b}\n\u0019&!\u0018\t\u0011\u0005U\u0013Q\na\u0001\u0003/\n!\"\u001b8qkR\u001c\u0006\u000f\\5u!\rq\u0011\u0011L\u0005\u0004\u00037z!AC%oaV$8\u000b\u001d7ji\"A\u0011qLA'\u0001\u0004\t\t'A\u0004d_:$X\r\u001f;\u0011\u00079\t\u0019'C\u0002\u0002f=\u0011!\u0003V1tW\u0006#H/Z7qi\u000e{g\u000e^3yi\"9\u0011\u0011\u000e\u0001\u0005B\u0005-\u0014aC4fiB\u0013xn\u001a:fgN$\"!!\u001c\u0011\u0007\t\ny'C\u0002\u0002r\r\u0012QA\u00127pCRDq!!\u001e\u0001\t\u0003\n9(\u0001\u0007oKb$8*Z=WC2,X\rF\u0001w\u0011\u001d\tY\b\u0001C!\u0003{\nqbZ3u\u0007V\u0014(/\u001a8u-\u0006dW/\u001a\u000b\u0002C!9\u0011\u0011\u0011\u0001\u0005B\u0005\r\u0015!D4fi\u000e+(O]3oi.+\u0017\u0010F\u0001\u001a\u0011\u001d\t9\t\u0001C!\u0003\u0013\u000bQa\u00197pg\u0016$\u0012a\u0010\u0005\b\u0003\u001b\u0003A\u0011BAH\u0003!1\u0017N\u001c3OKb$H#C.\u0002\u0012\u0006}\u0015\u0011VAW\u0011!\t\u0019*a#A\u0002\u0005U\u0015A\u00014t!\u0011\t9*a'\u000e\u0005\u0005e%bAAJ#%!\u0011QTAM\u0005)1\u0015\u000e\\3TsN$X-\u001c\u0005\t\u0003C\u000bY\t1\u0001\u0002$\u0006!a-\u001b7f!\u0011\t9*!*\n\t\u0005\u001d\u0016\u0011\u0014\u0002\u0005!\u0006$\b\u000eC\u0004\u0002,\u0006-\u0005\u0019A.\u0002\tML'0\u001a\u0005\b\u0003_\u000bY\t1\u0001\\\u0003\u0019ygMZ:fi\"9\u00111\u0017\u0001\u0005\n\u0005u\u0014!\u00038fqR4\u0016\r\\;f\u0001")
public class RedshiftRecordReader
extends RecordReader<Long, String[]> {
    private BufferedInputStream reader;
    private Long key;
    private String[] value;
    private long start;
    private long end;
    private long cur;
    private boolean eof = false;
    private byte io$github$spark_redshift_community$spark$redshift$RedshiftRecordReader$$delimiter;
    private final byte escapeChar = (byte)92;
    private final byte lineFeed = (byte)10;
    private final byte carriageReturn = (byte)13;
    private final int defaultBufferSize;
    private final ArrayBuffer<Object> chars = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();

    private BufferedInputStream reader() {
        return this.reader;
    }

    private void reader_$eq(BufferedInputStream x$1) {
        this.reader = x$1;
    }

    private Long key() {
        return this.key;
    }

    private void key_$eq(Long x$1) {
        this.key = x$1;
    }

    private String[] value() {
        return this.value;
    }

    private void value_$eq(String[] x$1) {
        this.value = x$1;
    }

    private long start() {
        return this.start;
    }

    private void start_$eq(long x$1) {
        this.start = x$1;
    }

    private long end() {
        return this.end;
    }

    private void end_$eq(long x$1) {
        this.end = x$1;
    }

    private long cur() {
        return this.cur;
    }

    private void cur_$eq(long x$1) {
        this.cur = x$1;
    }

    private boolean eof() {
        return this.eof;
    }

    private void eof_$eq(boolean x$1) {
        this.eof = x$1;
    }

    public byte io$github$spark_redshift_community$spark$redshift$RedshiftRecordReader$$delimiter() {
        return this.io$github$spark_redshift_community$spark$redshift$RedshiftRecordReader$$delimiter;
    }

    private void io$github$spark_redshift_community$spark$redshift$RedshiftRecordReader$$delimiter_$eq(byte x$1) {
        this.io$github$spark_redshift_community$spark$redshift$RedshiftRecordReader$$delimiter = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public void initialize(InputSplit inputSplit, TaskAttemptContext context) {
        void var4_4;
        FileSplit split = (FileSplit)inputSplit;
        Path file = split.getPath();
        Configuration conf = context.getConfiguration();
        this.io$github$spark_redshift_community$spark$redshift$RedshiftRecordReader$$delimiter_$eq((byte)RedshiftInputFormat$.MODULE$.getDelimiterOrDefault(conf));
        Predef$.MODULE$.require(this.io$github$spark_redshift_community$spark$redshift$RedshiftRecordReader$$delimiter() != this.escapeChar, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RedshiftRecordReader $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The delimiter and the escape char cannot be the same but found ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)this.$outer.io$github$spark_redshift_community$spark$redshift$RedshiftRecordReader$$delimiter())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.require(this.io$github$spark_redshift_community$spark$redshift$RedshiftRecordReader$$delimiter() != this.lineFeed, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The delimiter cannot be the lineFeed character.";
            }
        });
        Predef$.MODULE$.require(this.io$github$spark_redshift_community$spark$redshift$RedshiftRecordReader$$delimiter() != this.carriageReturn, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The delimiter cannot be the carriage return.";
            }
        });
        CompressionCodecFactory compressionCodecs = new CompressionCodecFactory(conf);
        CompressionCodec codec = compressionCodecs.getCodec(file);
        if (codec == null) {
            Object object;
            FileSystem fs = file.getFileSystem(conf);
            long size = fs.getFileStatus(file).getLen();
            this.start_$eq(this.findNext(fs, file, size, split.getStart()));
            this.end_$eq(this.findNext(fs, file, size, split.getStart() + split.getLength()));
            this.cur_$eq(this.start());
            FSDataInputStream in = fs.open(file);
            if (this.cur() > 0L) {
                in.seek(this.cur() - 1L);
                object = BoxesRunTime.boxToInteger((int)in.read());
            } else {
                object = BoxedUnit.UNIT;
            }
            this.reader_$eq(new BufferedInputStream((InputStream)in, 0x100000));
            return;
        }
        throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Do not support compressed files but found ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var4_4})));
    }

    public float getProgress() {
        return this.start() >= this.end() ? 1.0f : package$.MODULE$.min((float)(this.cur() - this.start()) / (float)(this.end() - this.start()), 1.0f);
    }

    public boolean nextKeyValue() {
        boolean bl;
        if (this.cur() < this.end() && !this.eof()) {
            this.key_$eq(Predef$.MODULE$.long2Long(this.cur()));
            this.value_$eq(this.nextValue());
            bl = true;
        } else {
            this.key_$eq(null);
            this.value_$eq(null);
            bl = false;
        }
        return bl;
    }

    public String[] getCurrentValue() {
        return this.value();
    }

    public Long getCurrentKey() {
        return this.key();
    }

    public void close() {
        if (this.reader() != null) {
            this.reader().close();
        }
    }

    /*
     * WARNING - void declaration
     */
    private long findNext(FileSystem fs, Path file, long size, long offset) {
        if (offset == 0L) {
            return 0L;
        }
        if (offset >= size) {
            return size;
        }
        FSDataInputStream in = fs.open(file);
        long pos = offset;
        in.seek(pos);
        BufferedInputStream bis = new BufferedInputStream((InputStream)in, 0x100000);
        boolean escaped = true;
        boolean thisEof = false;
        while (escaped && !thisEof) {
            int v = bis.read();
            if (v < 0) {
                thisEof = true;
                continue;
            }
            ++pos;
            if (v == this.escapeChar) continue;
            escaped = false;
        }
        boolean endOfRecord = false;
        while (true) {
            boolean bl;
            void var8_6;
            void var10_7;
            if (!escaped && endOfRecord || thisEof) {
                in.close();
                return pos;
            }
            int v = var10_7.read();
            if (v < 0) {
                boolean bl2 = true;
                continue;
            }
            ++var8_6;
            if (v == this.escapeChar) {
                bl = true;
                continue;
            }
            if (bl) {
                bl = false;
                continue;
            }
            boolean bl3 = v == this.lineFeed;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String[] nextValue() {
        ArrayBuffer fields = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        boolean escaped = false;
        boolean endOfRecord = false;
        block0: while (true) {
            if (endOfRecord || this.eof()) {
                if (escaped) {
                    throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found hanging escape char."})).s((Seq)Nil$.MODULE$));
                }
                return (String[])fields.toArray(ClassTag$.MODULE$.apply(String.class));
            }
            boolean endOfField = false;
            this.chars.clear();
            while (true) {
                boolean bl;
                boolean bl2;
                if (endOfField || bl2 || this.eof()) {
                    void var1_1;
                    var1_1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new String((byte[])this.chars.toArray(ClassTag$.MODULE$.Byte()), Charset.forName("UTF-8"))}));
                    continue block0;
                }
                int v = this.reader().read();
                if (v < 0) {
                    this.eof_$eq(true);
                    continue;
                }
                this.cur_$eq(this.cur() + 1L);
                byte c = (byte)v;
                if (bl) {
                    if (c != this.escapeChar && c != this.io$github$spark_redshift_community$spark$redshift$RedshiftRecordReader$$delimiter() && c != this.lineFeed && c != this.carriageReturn) {
                        throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found `", "` (ASCII ", ") after ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)c), BoxesRunTime.boxToInteger((int)v), BoxesRunTime.boxToByte((byte)this.escapeChar)})));
                    }
                    this.chars.append((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{c}));
                    bl = false;
                    continue;
                }
                if (c == this.escapeChar) {
                    bl = true;
                    continue;
                }
                if (c == this.io$github$spark_redshift_community$spark$redshift$RedshiftRecordReader$$delimiter()) {
                    boolean bl3 = true;
                    continue;
                }
                if (c == this.lineFeed) {
                    bl2 = true;
                    continue;
                }
                this.chars.append((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{c}));
            }
            break;
        }
    }
}

