/*
 * Decompiled with CFR 0.152.
 */
package io.github.spark_redshift_community.spark.redshift;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3Client;
import io.github.spark_redshift_community.spark.redshift.AWSCredentialsUtils$;
import io.github.spark_redshift_community.spark.redshift.Conversions$;
import io.github.spark_redshift_community.spark.redshift.JDBCWrapper;
import io.github.spark_redshift_community.spark.redshift.Parameters;
import io.github.spark_redshift_community.spark.redshift.RedshiftWriter$;
import io.github.spark_redshift_community.spark.redshift.TableName;
import io.github.spark_redshift_community.spark.redshift.Utils$;
import java.net.URI;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.Accumulable;
import org.apache.spark.TaskContext$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005Me!B\u0001\u0003\u0001\ta!A\u0004*fIND\u0017N\u001a;Xe&$XM\u001d\u0006\u0003\u0007\u0011\t\u0001B]3eg\"Lg\r\u001e\u0006\u0003\u000b\u0019\tQa\u001d9be.T!a\u0002\u0005\u00021M\u0004\u0018M]6`e\u0016$7\u000f[5gi~\u001bw.\\7v]&$\u0018P\u0003\u0002\n\u0015\u00051q-\u001b;ik\nT\u0011aC\u0001\u0003S>\u001c\"\u0001A\u0007\u0011\u00059\tR\"A\b\u000b\u0003A\tQa]2bY\u0006L!AE\b\u0003\r\u0005s\u0017PU3g\u0011!!\u0002A!A!\u0002\u00131\u0012a\u00036eE\u000e<&/\u00199qKJ\u001c\u0001\u0001\u0005\u0002\u001815\t!!\u0003\u0002\u001a\u0005\tY!\n\u0012\"D/J\f\u0007\u000f]3s\u0011!Y\u0002A!A!\u0002\u0013a\u0012aD:4\u00072LWM\u001c;GC\u000e$xN]=\u0011\t9ir$K\u0005\u0003==\u0011\u0011BR;oGRLwN\\\u0019\u0011\u0005\u0001:S\"A\u0011\u000b\u0005\t\u001a\u0013\u0001B1vi\"T!\u0001J\u0013\u0002\u0013\u0005l\u0017M_8oC^\u001c(\"\u0001\u0014\u0002\u0007\r|W.\u0003\u0002)C\t1\u0012iV*De\u0016$WM\u001c;jC2\u001c\bK]8wS\u0012,'\u000f\u0005\u0002+_5\t1F\u0003\u0002-[\u0005\u00111o\r\u0006\u0003]\r\n\u0001b]3sm&\u001cWm]\u0005\u0003a-\u0012a\"Q7bu>t7kM\"mS\u0016tG\u000fC\u00033\u0001\u0011\u00051'\u0001\u0004=S:LGO\u0010\u000b\u0004iU2\u0004CA\f\u0001\u0011\u0015!\u0012\u00071\u0001\u0017\u0011\u0015Y\u0012\u00071\u0001\u001d\u0011\u001dA\u0004A1A\u0005\ne\n1\u0001\\8h+\u0005Q\u0004CA\u001eA\u001b\u0005a$BA\u001f?\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005y\u0014aA8sO&\u0011\u0011\t\u0010\u0002\u0007\u0019><w-\u001a:\t\r\r\u0003\u0001\u0015!\u0003;\u0003\u0011awn\u001a\u0011\t\r\u0015\u0003A\u0011\u0001\u0002G\u00039\u0019'/Z1uKR\u000b'\r\\3Tc2$2a\u0012(h!\tA5J\u0004\u0002\u000f\u0013&\u0011!jD\u0001\u0007!J,G-\u001a4\n\u00051k%AB*ue&twM\u0003\u0002K\u001f!)q\n\u0012a\u0001!\u0006!A-\u0019;b!\t\tFM\u0004\u0002SC:\u00111K\u0018\b\u0003)rs!!\u0016.\u000f\u0005YKV\"A,\u000b\u0005a+\u0012A\u0002\u001fs_>$h(C\u0001@\u0013\tYf(\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003\u000buS!a\u0017 \n\u0005}\u0003\u0017aA:rY*\u0011Q!X\u0005\u0003E\u000e\fq\u0001]1dW\u0006<WM\u0003\u0002`A&\u0011QM\u001a\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T!AY2\t\u000b!$\u0005\u0019A5\u0002\rA\f'/Y7t!\tQwO\u0004\u0002lk:\u0011A\u000e\u001e\b\u0003[Nt!A\u001c:\u000f\u0005=\fhB\u0001,q\u0013\u0005Y\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002\u0006\r%\u00111\u0001B\u0005\u0003m\n\t!\u0002U1sC6,G/\u001a:t\u0013\tA\u0018P\u0001\tNKJ<W\r\u001a)be\u0006lW\r^3sg*\u0011aO\u0001\u0005\u0006w\u0002!I\u0001`\u0001\bG>\u0004\u0018pU9m)!9U0a\u0002\u0002\n\u00055\u0001\"\u0002@{\u0001\u0004y\u0018AC:rY\u000e{g\u000e^3yiB!\u0011\u0011AA\u0002\u001b\u0005\u0019\u0017bAA\u0003G\nQ1+\u0015'D_:$X\r\u001f;\t\u000b!T\b\u0019A5\t\r\u0005-!\u00101\u0001 \u0003\u0015\u0019'/\u001a3t\u0011\u0019\tyA\u001fa\u0001\u000f\u0006YQ.\u00198jM\u0016\u001cH/\u0016:m\u0011!\t\u0019\u0002\u0001C\u0001\u0005\u0005U\u0011AD2p[6,g\u000e^!di&|gn\u001d\u000b\u0007\u0003/\t9#!\r\u0011\u000b\u0005e\u0011\u0011E$\u000f\t\u0005m\u0011q\u0004\b\u0004-\u0006u\u0011\"\u0001\t\n\u0005\t|\u0011\u0002BA\u0012\u0003K\u0011A\u0001T5ti*\u0011!m\u0004\u0005\t\u0003S\t\t\u00021\u0001\u0002,\u0005aA/\u00192mK\u000e{W.\\3oiB!a\"!\fH\u0013\r\tyc\u0004\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011\u0005M\u0012\u0011\u0003a\u0001\u0003k\taa]2iK6\f\u0007\u0003BA\u001c\u0003{i!!!\u000f\u000b\u0007\u0005m2-A\u0003usB,7/\u0003\u0003\u0002@\u0005e\"AC*ueV\u001cG\u000fV=qK\"9\u00111\t\u0001\u0005\n\u0005\u0015\u0013A\u00043p%\u0016$7\u000f[5gi2{\u0017\r\u001a\u000b\r\u0003\u000f\ni%a\u0018\u0002b\u0005\r\u0014Q\r\t\u0004\u001d\u0005%\u0013bAA&\u001f\t!QK\\5u\u0011!\ty%!\u0011A\u0002\u0005E\u0013\u0001B2p]:\u0004B!a\u0015\u0002\\5\u0011\u0011Q\u000b\u0006\u0004?\u0006]#BAA-\u0003\u0011Q\u0017M^1\n\t\u0005u\u0013Q\u000b\u0002\u000b\u0007>tg.Z2uS>t\u0007BB(\u0002B\u0001\u0007\u0001\u000b\u0003\u0004i\u0003\u0003\u0002\r!\u001b\u0005\b\u0003\u0017\t\t\u00051\u0001 \u0011!\ty!!\u0011A\u0002\u0005-\u0002bBA5\u0001\u0011%\u00111N\u0001\u000bk:dw.\u00193ECR\fG\u0003DA\u0016\u0003[\ny'!\u001d\u0002v\u0005e\u0004B\u0002@\u0002h\u0001\u0007q\u0010\u0003\u0004P\u0003O\u0002\r\u0001\u0015\u0005\b\u0003g\n9\u00071\u0001H\u0003\u001d!X-\u001c9ESJDq!a\u001e\u0002h\u0001\u0007q)\u0001\u0006uK6\u0004hi\u001c:nCRDq!a\u001f\u0002h\u0001\u0007q)\u0001\u0006ok2d7\u000b\u001e:j]\u001eDq!a \u0001\t\u0003\t\t)\u0001\btCZ,Gk\u001c*fIND\u0017N\u001a;\u0015\u0015\u0005\u001d\u00131QAC\u0003\u000f\u000b\t\n\u0003\u0004\u007f\u0003{\u0002\ra \u0005\u0007\u001f\u0006u\u0004\u0019\u0001)\t\u0011\u0005%\u0015Q\u0010a\u0001\u0003\u0017\u000b\u0001b]1wK6{G-\u001a\t\u0005\u0003\u0003\ti)C\u0002\u0002\u0010\u000e\u0014\u0001bU1wK6{G-\u001a\u0005\u0007Q\u0006u\u0004\u0019A5")
public class RedshiftWriter {
    public final JDBCWrapper io$github$spark_redshift_community$spark$redshift$RedshiftWriter$$jdbcWrapper;
    public final Function1<AWSCredentialsProvider, AmazonS3Client> io$github$spark_redshift_community$spark$redshift$RedshiftWriter$$s3ClientFactory;
    private final Logger io$github$spark_redshift_community$spark$redshift$RedshiftWriter$$log;

    public Logger io$github$spark_redshift_community$spark$redshift$RedshiftWriter$$log() {
        return this.io$github$spark_redshift_community$spark$redshift$RedshiftWriter$$log;
    }

    public String createTableSql(Dataset<Row> data, Parameters.MergedParameters params) {
        Option<String> option;
        block4: {
            Option<String> option2;
            block7: {
                String string;
                String distStyleDef;
                String schemaSql;
                block6: {
                    block5: {
                        String string2;
                        block3: {
                            block2: {
                                schemaSql = this.io$github$spark_redshift_community$spark$redshift$RedshiftWriter$$jdbcWrapper.schemaString(data.schema());
                                option = params.distStyle();
                                if (!(option instanceof Some)) break block2;
                                Some some = (Some)option;
                                String style = (String)some.x();
                                string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DISTSTYLE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{style}));
                                break block3;
                            }
                            if (!None$.MODULE$.equals(option)) break block4;
                            string2 = "";
                        }
                        distStyleDef = string2;
                        option2 = params.distKey();
                        if (!(option2 instanceof Some)) break block5;
                        Some some = (Some)option2;
                        String key = (String)some.x();
                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DISTKEY (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key}));
                        break block6;
                    }
                    if (!None$.MODULE$.equals(option2)) break block7;
                    string = "";
                }
                String distKeyDef = string;
                String sortKeyDef = (String)params.sortKeySpec().getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                });
                TableName table2 = (TableName)params.table().get();
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE TABLE IF NOT EXISTS ", " (", ") ", " ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table2, schemaSql, distStyleDef, distKeyDef, sortKeyDef}));
            }
            throw new MatchError(option2);
        }
        throw new MatchError(option);
    }

    public String io$github$spark_redshift_community$spark$redshift$RedshiftWriter$$copySql(SQLContext sqlContext, Parameters.MergedParameters params, AWSCredentialsProvider creds, String manifestUrl) {
        String string;
        block5: {
            String string2;
            String fixedUrl;
            String credsString;
            block3: {
                block4: {
                    block2: {
                        credsString = AWSCredentialsUtils$.MODULE$.getRedshiftCredentialsString(params, creds.getCredentials());
                        fixedUrl = Utils$.MODULE$.fixS3Url(manifestUrl);
                        string = params.tempFormat();
                        if (!"AVRO".equals(string)) break block2;
                        string2 = "AVRO 'auto'";
                        break block3;
                    }
                    String string3 = string;
                    String string4 = "CSV";
                    if (!(string3 == null ? string4 != null : !string3.equals(string4))) break block4;
                    String string5 = string;
                    String string6 = "CSV GZIP";
                    if (string5 != null ? !string5.equals(string6) : string6 != null) break block5;
                }
                string2 = new StringBuilder().append((Object)string).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" NULL AS '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params.nullString()}))).toString();
            }
            String format = string2;
            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"COPY ", " FROM '", "' CREDENTIALS '", "' FORMAT AS "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params.table().get(), fixedUrl, credsString}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " manifest ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{format, params.extraCopyOptions()}))).toString();
        }
        throw new MatchError((Object)string);
    }

    public List<String> commentActions(Option<String> tableComment, StructType schema2) {
        return (List)((List)tableComment.toList().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String desc) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"COMMENT ON TABLE %s IS '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desc.replace("'", "''")}));
            }
        }, List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])schema2.fields()).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructField f) {
                return f.metadata().contains("description");
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField f) {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"COMMENT ON COLUMN %s.\"", "\""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{f.name().replace("\"", "\\\"")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" IS '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{f.metadata().getString("description").replace("'", "''")}))).toString();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))), List$.MODULE$.canBuildFrom());
    }

    private void doRedshiftLoad(Connection conn, Dataset<Row> data, Parameters.MergedParameters params, AWSCredentialsProvider creds, Option<String> manifestUrl) {
        String createStatement = this.createTableSql(data, params);
        this.io$github$spark_redshift_community$spark$redshift$RedshiftWriter$$log().info(createStatement);
        this.io$github$spark_redshift_community$spark$redshift$RedshiftWriter$$jdbcWrapper.executeInterruptibly(conn.prepareStatement(createStatement));
        List preActions = (List)this.commentActions(params.description(), data.schema()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])params.preActions()), List$.MODULE$.canBuildFrom());
        preActions.foreach((Function1)new Serializable(this, conn, params){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RedshiftWriter $outer;
            private final Connection conn$1;
            private final Parameters.MergedParameters params$2;

            public final boolean apply(String action) {
                String actionSql = action.contains("%s") ? new StringOps(Predef$.MODULE$.augmentString(action)).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.params$2.table().get()})) : action;
                this.$outer.io$github$spark_redshift_community$spark$redshift$RedshiftWriter$$log().info(new StringBuilder().append((Object)"Executing preAction: ").append((Object)actionSql).toString());
                return this.$outer.io$github$spark_redshift_community$spark$redshift$RedshiftWriter$$jdbcWrapper.executeInterruptibly(this.conn$1.prepareStatement(actionSql));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.conn$1 = conn$1;
                this.params$2 = params$2;
            }
        });
        manifestUrl.foreach((Function1)new Serializable(this, conn, data, params, creds){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RedshiftWriter $outer;
            private final Connection conn$1;
            private final Dataset data$1;
            private final Parameters.MergedParameters params$2;
            private final AWSCredentialsProvider creds$1;

            public final boolean apply(String manifestUrl) {
                String copyStatement = this.$outer.io$github$spark_redshift_community$spark$redshift$RedshiftWriter$$copySql(this.data$1.sqlContext(), this.params$2, this.creds$1, manifestUrl);
                this.$outer.io$github$spark_redshift_community$spark$redshift$RedshiftWriter$$log().info(copyStatement);
                try {
                    return this.$outer.io$github$spark_redshift_community$spark$redshift$RedshiftWriter$$jdbcWrapper.executeInterruptibly(this.conn$1.prepareStatement(copyStatement));
                }
                catch (SQLException sQLException) {
                    None$ none$;
                    this.$outer.io$github$spark_redshift_community$spark$redshift$RedshiftWriter$$log().error("SQLException thrown while running COPY query; will attempt to retrieve more information by querying the STL_LOAD_ERRORS table", (Throwable)sQLException);
                    this.conn$1.rollback();
                    String errorLookupQuery = new StringOps(Predef$.MODULE$.augmentString("\n              | SELECT *\n              | FROM stl_load_errors\n              | WHERE query = pg_last_query_id()\n            ")).stripMargin();
                    try {
                        ResultSet results = this.$outer.io$github$spark_redshift_community$spark$redshift$RedshiftWriter$$jdbcWrapper.executeQueryInterruptibly(this.conn$1.prepareStatement(errorLookupQuery));
                        if (results.next()) {
                            int errCode = results.getInt("err_code");
                            String errReason = results.getString("err_reason").trim();
                            String columnLength = (String)Option$.MODULE$.apply((Object)results.getString("col_length")).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply(String x$1) {
                                    return x$1.trim();
                                }
                            }).filter((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(String x$2) {
                                    return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
                                }
                            }).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply(String n) {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{n}));
                                }
                            }).getOrElse((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "";
                                }
                            });
                            String exceptionMessage = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n                   |Error (code ", ") while loading data into Redshift: \"", "\"\n                   |Table name: ", "\n                   |Column name: ", "\n                   |Column type: ", "", "\n                   |Raw line: ", "\n                   |Raw field value: ", "\n                  "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)errCode), errReason, this.params$2.table().get(), results.getString("colname").trim(), results.getString("type").trim(), columnLength, results.getString("raw_line"), results.getString("raw_field_value")})))).stripMargin();
                            none$ = new Some((Object)new SQLException(exceptionMessage, sQLException));
                        } else {
                            none$ = None$.MODULE$;
                        }
                    }
                    catch (Throwable throwable) {
                        None$ none$2;
                        Throwable throwable2 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (option.isEmpty()) {
                            throw throwable;
                        }
                        Throwable e2 = (Throwable)option.get();
                        this.$outer.io$github$spark_redshift_community$spark$redshift$RedshiftWriter$$log().error("Error occurred while querying STL_LOAD_ERRORS", e2);
                        none$ = none$2 = None$.MODULE$;
                    }
                    None$ detailedException = none$;
                    throw (Throwable)detailedException.getOrElse((Function0)new Serializable(this, sQLException){
                        public static final long serialVersionUID = 0L;
                        private final SQLException e$1;

                        public final SQLException apply() {
                            return this.e$1;
                        }
                        {
                            this.e$1 = e$1;
                        }
                    });
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.conn$1 = conn$1;
                this.data$1 = data$1;
                this.params$2 = params$2;
                this.creds$1 = creds$1;
            }
        });
        Predef$.MODULE$.refArrayOps((Object[])params.postActions()).foreach((Function1)new Serializable(this, conn, params){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RedshiftWriter $outer;
            private final Connection conn$1;
            private final Parameters.MergedParameters params$2;

            public final boolean apply(String action) {
                String actionSql = action.contains("%s") ? new StringOps(Predef$.MODULE$.augmentString(action)).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.params$2.table().get()})) : action;
                this.$outer.io$github$spark_redshift_community$spark$redshift$RedshiftWriter$$log().info(new StringBuilder().append((Object)"Executing postAction: ").append((Object)actionSql).toString());
                return this.$outer.io$github$spark_redshift_community$spark$redshift$RedshiftWriter$$jdbcWrapper.executeInterruptibly(this.conn$1.prepareStatement(actionSql));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.conn$1 = conn$1;
                this.params$2 = params$2;
            }
        });
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Option<String> unloadData(SQLContext sqlContext, Dataset<Row> data, String tempDir, String tempFormat, String nullString) {
        None$ none$;
        DataFrameWriter dataFrameWriter;
        Function1[] conversionFunctions = (Function1[])Predef$.MODULE$.refArrayOps((Object[])data.schema().fields()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Function1<Object, Object> apply(StructField field) {
                Object object;
                DataType dataType = field.dataType();
                if (dataType instanceof DecimalType) {
                    object = new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Object v) {
                            return v == null ? null : v.toString();
                        }
                    };
                } else if (DateType$.MODULE$.equals(dataType)) {
                    SimpleDateFormat dateFormat = Conversions$.MODULE$.createRedshiftDateFormat();
                    object = new Serializable(this, dateFormat){
                        public static final long serialVersionUID = 0L;
                        private final SimpleDateFormat dateFormat$1;

                        public final String apply(Object v) {
                            return v == null ? null : this.dateFormat$1.format((Date)v);
                        }
                        {
                            this.dateFormat$1 = dateFormat$1;
                        }
                    };
                } else if (TimestampType$.MODULE$.equals(dataType)) {
                    SimpleDateFormat timestampFormat = Conversions$.MODULE$.createRedshiftTimestampFormat();
                    object = new Serializable(this, timestampFormat){
                        public static final long serialVersionUID = 0L;
                        private final SimpleDateFormat timestampFormat$1;

                        public final String apply(Object v) {
                            return v == null ? null : this.timestampFormat$1.format((Timestamp)v);
                        }
                        {
                            this.timestampFormat$1 = timestampFormat$1;
                        }
                    };
                } else {
                    object = new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Object apply(Object v) {
                            return v;
                        }
                    };
                }
                return object;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Function1.class)));
        Accumulable nonEmptyPartitions = sqlContext.sparkContext().accumulableCollection((Object)HashSet$.MODULE$.empty(), (Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.apply(HashSet.class));
        RDD convertedRows = data.rdd().mapPartitions((Function1)new Serializable(this, conversionFunctions, nonEmptyPartitions){
            public static final long serialVersionUID = 0L;
            public final Function1[] conversionFunctions$1;
            private final Accumulable nonEmptyPartitions$1;

            public final Iterator<Row> apply(Iterator<Row> iter) {
                if (iter.hasNext()) {
                    this.nonEmptyPartitions$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)TaskContext$.MODULE$.get().partitionId()));
                }
                return iter.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;

                    public final Row apply(Row row) {
                        Object[] convertedValues = new Object[this.$outer.conversionFunctions$1.length];
                        for (int i = 0; i < this.$outer.conversionFunctions$1.length; ++i) {
                            convertedValues[i] = this.$outer.conversionFunctions$1[i].apply(row.apply(i));
                        }
                        return Row$.MODULE$.fromSeq((Seq)Predef$.MODULE$.genericWrapArray((Object)convertedValues));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.conversionFunctions$1 = conversionFunctions$1;
                this.nonEmptyPartitions$1 = nonEmptyPartitions$1;
            }
        }, data.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(Row.class));
        StructType schemaWithLowercaseColumnNames = StructType$.MODULE$.apply((Seq)data.schema().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final StructField apply(StructField f) {
                return f.copy(f.name().toLowerCase(), f.copy$default$2(), f.copy$default$3(), f.copy$default$4());
            }
        }, Seq$.MODULE$.canBuildFrom()));
        if (((TraversableOnce)schemaWithLowercaseColumnNames.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField x$3) {
                return x$3.name();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet().size() != data.schema().size()) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Cannot save table to Redshift because two or more column names would be identical after conversion to lowercase: ").append((Object)((TraversableOnce)data.schema().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(StructField x$4) {
                    return x$4.name();
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString(", ")).toString());
        }
        StructType convertedSchema = StructType$.MODULE$.apply((Seq)schemaWithLowercaseColumnNames.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final StructField apply(StructField x0$1) {
                StructField structField = x0$1;
                if (structField != null) {
                    String name = structField.name();
                    boolean nullable = structField.nullable();
                    Metadata meta = structField.metadata();
                    if (structField.dataType() instanceof DecimalType) {
                        return new StructField(name, (DataType)StringType$.MODULE$, nullable, meta);
                    }
                }
                if (structField != null) {
                    String name = structField.name();
                    DataType dataType = structField.dataType();
                    boolean nullable = structField.nullable();
                    Metadata meta = structField.metadata();
                    if (DateType$.MODULE$.equals(dataType)) {
                        return new StructField(name, (DataType)StringType$.MODULE$, nullable, meta);
                    }
                }
                if (structField == null) return structField;
                String name = structField.name();
                DataType dataType = structField.dataType();
                boolean nullable = structField.nullable();
                Metadata meta = structField.metadata();
                if (!TimestampType$.MODULE$.equals(dataType)) return structField;
                return new StructField(name, (DataType)StringType$.MODULE$, nullable, meta);
            }
        }, Seq$.MODULE$.canBuildFrom()));
        DataFrameWriter writer = sqlContext.createDataFrame(convertedRows, convertedSchema).write();
        String string = tempFormat;
        if ("AVRO".equals(string)) {
            dataFrameWriter = writer.format("avro");
        } else if ("CSV".equals(string)) {
            dataFrameWriter = writer.format("csv").option("escape", "\"").option("nullValue", nullString);
        } else {
            if (!"CSV GZIP".equals(string)) throw new MatchError((Object)string);
            dataFrameWriter = writer.format("csv").option("escape", "\"").option("nullValue", nullString).option("compression", "gzip");
        }
        dataFrameWriter.save(tempDir);
        if (((SetLike)nonEmptyPartitions.value()).isEmpty()) {
            none$ = None$.MODULE$;
            return none$;
        }
        FileSystem fs = FileSystem.get((URI)URI.create(tempDir), (Configuration)sqlContext.sparkContext().hadoopConfiguration());
        Regex partitionIdRegex = new StringOps(Predef$.MODULE$.augmentString("^part-(?:r-)?(\\d+)[^\\d+].*$")).r();
        Set nonEmptyPartitionIds = ((TraversableOnce)nonEmptyPartitions.value()).toSet();
        Seq filesToLoad = (Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(new Path(tempDir))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(FileStatus x$5) {
                return x$5.getPath().getName();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).collect((PartialFunction)new Serializable(this, partitionIdRegex, nonEmptyPartitionIds){
            public static final long serialVersionUID = 0L;
            private final Regex partitionIdRegex$1;
            private final Set nonEmptyPartitionIds$1;

            public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                String id;
                A1 A1 = x1;
                Option option = this.partitionIdRegex$1.unapplySeq(A1);
                Object object = !option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0 && this.nonEmptyPartitionIds$1.contains((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(id = (String)((LinearSeqOptimized)option.get()).apply(0))).toInt())) ? A1 : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(String x1) {
                String id;
                String string = x1;
                Option option = this.partitionIdRegex$1.unapplySeq((CharSequence)string);
                boolean bl = !option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0 && this.nonEmptyPartitionIds$1.contains((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(id = (String)((LinearSeqOptimized)option.get()).apply(0))).toInt()));
                return bl;
            }
            {
                this.partitionIdRegex$1 = partitionIdRegex$1;
                this.nonEmptyPartitionIds$1 = nonEmptyPartitionIds$1;
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        String sanitizedTempDir = new StringOps(Predef$.MODULE$.augmentString(Utils$.MODULE$.fixS3Url(Utils$.MODULE$.removeCredentialsFromURI(URI.create(tempDir)).toString()))).stripSuffix("/");
        Seq manifestEntries = (Seq)filesToLoad.map((Function1)new Serializable(this, sanitizedTempDir){
            public static final long serialVersionUID = 0L;
            private final String sanitizedTempDir$1;

            public final String apply(String file) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"url\":\"", "/", "\", \"mandatory\":true}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.sanitizedTempDir$1, file}));
            }
            {
                this.sanitizedTempDir$1 = sanitizedTempDir$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        String manifest = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"entries\": [", "]}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{manifestEntries.mkString(",\n")}));
        String manifestPath = new StringBuilder().append((Object)sanitizedTempDir).append((Object)"/manifest.json").toString();
        FSDataOutputStream fsDataOut = fs.create(new Path(manifestPath));
        try {
            fsDataOut.write(manifest.getBytes("utf-8"));
        }
        catch (Throwable throwable) {
            void var22_22;
            var22_22.close();
            throw throwable;
        }
        fsDataOut.close();
        none$ = new Some((Object)manifestPath);
        return none$;
    }

    /*
     * WARNING - void declaration
     */
    public void saveToRedshift(SQLContext sqlContext, Dataset<Row> data, SaveMode saveMode, Parameters.MergedParameters params) {
        if (params.table().isEmpty()) {
            throw new IllegalArgumentException("For save operations you must specify a Redshift table name with the 'dbtable' parameter");
        }
        if (!params.useStagingTable()) {
            this.io$github$spark_redshift_community$spark$redshift$RedshiftWriter$$log().warn("Setting useStagingTable=false is deprecated; instead, we recommend that you drop the target table yourself. For more details on this deprecation, seehttps://github.com/databricks/spark-redshift/pull/157");
        }
        AWSCredentialsProvider creds = AWSCredentialsUtils$.MODULE$.load(params, sqlContext.sparkContext().hadoopConfiguration());
        Utils$.MODULE$.getRegionForRedshiftCluster(params.jdbcUrl()).foreach((Function1)new Serializable(this, params, creds){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RedshiftWriter $outer;
            public final Parameters.MergedParameters params$1;
            private final AWSCredentialsProvider creds$2;

            public final void apply(String redshiftRegion) {
                Utils$.MODULE$.getRegionForS3Bucket(this.params$1.rootTempDir(), (AmazonS3Client)this.$outer.io$github$spark_redshift_community$spark$redshift$RedshiftWriter$$s3ClientFactory.apply((Object)this.creds$2)).foreach((Function1)new Serializable(this, redshiftRegion){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$saveToRedshift$1 $outer;
                    private final String redshiftRegion$1;

                    public final void apply(String s3Region) {
                        boolean regionIsSetInExtraCopyOptions = this.$outer.params$1.extraCopyOptions().contains(s3Region) && this.$outer.params$1.extraCopyOptions().contains("region");
                        String string = this.redshiftRegion$1;
                        String string2 = s3Region;
                        if ((string == null ? string2 != null : !string.equals(string2)) && !regionIsSetInExtraCopyOptions) {
                            this.$outer.io$github$spark_redshift_community$spark$redshift$RedshiftWriter$$anonfun$$$outer().io$github$spark_redshift_community$spark$redshift$RedshiftWriter$$log().error(new StringBuilder().append((Object)"The Redshift cluster and S3 bucket are in different regions ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", " and ", ", respectively). In order to perform this cross-region "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.redshiftRegion$1, s3Region}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"write, you must add \"region '", "'\" to the extracopyoptions parameter. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s3Region}))).append((Object)"For more details on cross-region usage, see the README.").toString());
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.redshiftRegion$1 = redshiftRegion$1;
                    }
                });
            }

            public /* synthetic */ RedshiftWriter io$github$spark_redshift_community$spark$redshift$RedshiftWriter$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.params$1 = params$1;
                this.creds$2 = creds$2;
            }
        });
        String string = params.tempFormat();
        String string2 = "AVRO";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Predef$.MODULE$.refArrayOps((Object[])data.schema().fieldNames()).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(String fieldName) {
                    boolean isValid;
                    char firstChar = fieldName.charAt(0);
                    boolean bl = isValid = (RichChar$.MODULE$.isLetter$extension(Predef$.MODULE$.charWrapper(firstChar)) || firstChar == '_') && new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(fieldName)).tail())).forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(char c) {
                            return RichChar$.MODULE$.isLetterOrDigit$extension(Predef$.MODULE$.charWrapper(c)) || c == '_';
                        }
                    });
                    if (isValid) {
                        return;
                    }
                    throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The field name '", "' is not supported when using the Avro tempformat. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fieldName}))).append((Object)"Try using the CSV tempformat  instead. For more details, see ").append((Object)"https://github.com/databricks/spark-redshift/issues/84").toString());
                }
            });
        }
        Utils$.MODULE$.assertThatFileSystemIsNotS3BlockFileSystem(new URI(params.rootTempDir()), sqlContext.sparkContext().hadoopConfiguration());
        Utils$.MODULE$.checkThatBucketHasObjectLifecycleConfiguration(params.rootTempDir(), (AmazonS3Client)this.io$github$spark_redshift_community$spark$redshift$RedshiftWriter$$s3ClientFactory.apply((Object)creds));
        Option<String> manifestUrl = this.unloadData(sqlContext, data, params.createPerQueryTempDir(), params.tempFormat(), params.nullString());
        Connection conn = this.io$github$spark_redshift_community$spark$redshift$RedshiftWriter$$jdbcWrapper.getConnector(params.jdbcDriver(), params.jdbcUrl(), params.credentials());
        conn.setAutoCommit(false);
        try {
            TableName table2 = (TableName)params.table().get();
            SaveMode saveMode2 = saveMode;
            SaveMode saveMode3 = SaveMode.Overwrite;
            if (!(saveMode2 != null ? !saveMode2.equals(saveMode3) : saveMode3 != null)) {
                this.io$github$spark_redshift_community$spark$redshift$RedshiftWriter$$jdbcWrapper.executeInterruptibly(conn.prepareStatement(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DROP TABLE IF EXISTS ", ";"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table2}))));
                if (!params.useStagingTable()) {
                    conn.commit();
                }
            }
            this.io$github$spark_redshift_community$spark$redshift$RedshiftWriter$$log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading new Redshift data to: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table2})));
            this.doRedshiftLoad(conn, data, params, creds, manifestUrl);
            conn.commit();
        }
        catch (Throwable throwable) {
            void var8_8;
            try {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                try {
                    this.io$github$spark_redshift_community$spark$redshift$RedshiftWriter$$log().error("Exception thrown during Redshift load; will roll back transaction", e);
                    var8_8.rollback();
                }
                catch (Throwable throwable3) {
                    Throwable throwable4 = throwable3;
                    Option option2 = NonFatal$.MODULE$.unapply(throwable4);
                    if (option2.isEmpty()) {
                        throw throwable3;
                    }
                    Throwable e2 = (Throwable)option2.get();
                    this.io$github$spark_redshift_community$spark$redshift$RedshiftWriter$$log().error("Exception while rolling back transaction", e2);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                throw e;
            }
            catch (Throwable throwable5) {
                var8_8.close();
                throw throwable5;
            }
        }
        conn.close();
    }

    public RedshiftWriter(JDBCWrapper jdbcWrapper, Function1<AWSCredentialsProvider, AmazonS3Client> s3ClientFactory) {
        this.io$github$spark_redshift_community$spark$redshift$RedshiftWriter$$jdbcWrapper = jdbcWrapper;
        this.io$github$spark_redshift_community$spark$redshift$RedshiftWriter$$s3ClientFactory = s3ClientFactory;
        this.io$github$spark_redshift_community$spark$redshift$RedshiftWriter$$log = LoggerFactory.getLogger(this.getClass());
    }
}

