/*
 * Decompiled with CFR 0.152.
 */
package io.github.spark_redshift_community.spark.redshift;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3Client;
import io.github.spark_redshift_community.spark.redshift.AWSCredentialsUtils$;
import io.github.spark_redshift_community.spark.redshift.Conversions$;
import io.github.spark_redshift_community.spark.redshift.JDBCWrapper;
import io.github.spark_redshift_community.spark.redshift.Parameters;
import io.github.spark_redshift_community.spark.redshift.SetAccumulator;
import io.github.spark_redshift_community.spark.redshift.TableName;
import io.github.spark_redshift_community.spark.redshift.Utils$;
import java.io.Serializable;
import java.net.URI;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.TaskContext$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005]e!\u0002\u0007\u000e\u000159\u0002\u0002\u0003\u0010\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0011\t\u0011\u0011\u0002!\u0011!Q\u0001\n\u0015BQA\u000f\u0001\u0005\u0002mBqa\u0010\u0001C\u0002\u0013%\u0001\t\u0003\u0004J\u0001\u0001\u0006I!\u0011\u0005\u0007\u0015\u0002!\t!D&\t\u000f\u0005\u0005\u0001\u0001\"\u0003\u0002\u0004!A\u00111\u0006\u0001\u0005\u00025\ti\u0003C\u0004\u0002L\u0001!I!!\u0014\t\u000f\u0005=\u0004\u0001\"\u0003\u0002r!9\u00111\u0011\u0001\u0005\u0002\u0005\u0015%A\u0004*fIND\u0017N\u001a;Xe&$XM\u001d\u0006\u0003\u001d=\t\u0001B]3eg\"Lg\r\u001e\u0006\u0003!E\tQa\u001d9be.T!AE\n\u00021M\u0004\u0018M]6`e\u0016$7\u000f[5gi~\u001bw.\\7v]&$\u0018P\u0003\u0002\u0015+\u00051q-\u001b;ik\nT\u0011AF\u0001\u0003S>\u001c\"\u0001\u0001\r\u0011\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\r\u0005s\u0017PU3g\u0003-QGMY2Xe\u0006\u0004\b/\u001a:\u0004\u0001A\u0011\u0011EI\u0007\u0002\u001b%\u00111%\u0004\u0002\f\u0015\u0012\u00135i\u0016:baB,'/A\btg\rc\u0017.\u001a8u\r\u0006\u001cGo\u001c:z!\u0011Ib\u0005\u000b\u001a\n\u0005\u001dR\"!\u0003$v]\u000e$\u0018n\u001c82!\tI\u0003'D\u0001+\u0015\tYC&\u0001\u0003bkRD'BA\u0017/\u0003%\tW.\u0019>p]\u0006<8OC\u00010\u0003\r\u0019w.\\\u0005\u0003c)\u0012a#Q,T\u0007J,G-\u001a8uS\u0006d7\u000f\u0015:pm&$WM\u001d\t\u0003gaj\u0011\u0001\u000e\u0006\u0003kY\n!a]\u001a\u000b\u0005]b\u0013\u0001C:feZL7-Z:\n\u0005e\"$AD!nCj|gnU\u001aDY&,g\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007qjd\b\u0005\u0002\"\u0001!)ad\u0001a\u0001A!)Ae\u0001a\u0001K\u0005\u0019An\\4\u0016\u0003\u0005\u0003\"AQ$\u000e\u0003\rS!\u0001R#\u0002\u000bMdg\r\u000e6\u000b\u0003\u0019\u000b1a\u001c:h\u0013\tA5I\u0001\u0004M_\u001e<WM]\u0001\u0005Y><\u0007%\u0001\bde\u0016\fG/\u001a+bE2,7+\u001d7\u0015\u00071;V\u000e\u0005\u0002N):\u0011aJ\u0015\t\u0003\u001fji\u0011\u0001\u0015\u0006\u0003#~\ta\u0001\u0010:p_Rt\u0014BA*\u001b\u0003\u0019\u0001&/\u001a3fM&\u0011QK\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005MS\u0002\"\u0002-\u0007\u0001\u0004I\u0016\u0001\u00023bi\u0006\u0004\"A\u00176\u000f\u0005m;gB\u0001/e\u001d\ti&M\u0004\u0002_A:\u0011qjX\u0005\u0002\r&\u0011\u0011-R\u0001\u0007CB\f7\r[3\n\u0005A\u0019'BA1F\u0013\t)g-A\u0002tc2T!\u0001E2\n\u0005!L\u0017a\u00029bG.\fw-\u001a\u0006\u0003K\u001aL!a\u001b7\u0003\u0013\u0011\u000bG/\u0019$sC6,'B\u00015j\u0011\u0015qg\u00011\u0001p\u0003\u0019\u0001\u0018M]1ngB\u0011\u0001/ \b\u0003cnt!A\u001d>\u000f\u0005MLhB\u0001;y\u001d\t)xO\u0004\u0002Pm&\ta#\u0003\u0002\u0015+%\u0011!cE\u0005\u0003!EI!AD\b\n\u0005ql\u0011A\u0003)be\u0006lW\r^3sg&\u0011ap \u0002\u0011\u001b\u0016\u0014x-\u001a3QCJ\fW.\u001a;feNT!\u0001`\u0007\u0002\u000f\r|\u0007/_*rYRYA*!\u0002\u0002\u0012\u0005\u0005\u00121EA\u0014\u0011\u001d\t9a\u0002a\u0001\u0003\u0013\t!b]9m\u0007>tG/\u001a=u!\u0011\tY!!\u0004\u000e\u0003%L1!a\u0004j\u0005)\u0019\u0016\u000bT\"p]R,\u0007\u0010\u001e\u0005\b\u0003'9\u0001\u0019AA\u000b\u0003\u0019\u00198\r[3nCB!\u0011qCA\u000f\u001b\t\tIBC\u0002\u0002\u001c%\fQ\u0001^=qKNLA!a\b\u0002\u001a\tQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000b9<\u0001\u0019A8\t\r\u0005\u0015r\u00011\u0001)\u0003\u0015\u0019'/\u001a3t\u0011\u0019\tIc\u0002a\u0001\u0019\u0006YQ.\u00198jM\u0016\u001cH/\u0016:m\u00039\u0019w.\\7f]R\f5\r^5p]N$b!a\f\u0002@\u0005%\u0003#BA\u0019\u0003sae\u0002BA\u001a\u0003oq1aTA\u001b\u0013\u0005Y\u0012B\u00015\u001b\u0013\u0011\tY$!\u0010\u0003\t1K7\u000f\u001e\u0006\u0003QjAq!!\u0011\t\u0001\u0004\t\u0019%\u0001\u0007uC\ndWmQ8n[\u0016tG\u000f\u0005\u0003\u001a\u0003\u000bb\u0015bAA$5\t1q\n\u001d;j_:Dq!a\u0005\t\u0001\u0004\t)\"\u0001\be_J+Gm\u001d5jMRdu.\u00193\u0015\u0019\u0005=\u0013QKA4\u0003S\nY'!\u001c\u0011\u0007e\t\t&C\u0002\u0002Ti\u0011A!\u00168ji\"9\u0011qK\u0005A\u0002\u0005e\u0013\u0001B2p]:\u0004B!a\u0017\u0002d5\u0011\u0011Q\f\u0006\u0004K\u0006}#BAA1\u0003\u0011Q\u0017M^1\n\t\u0005\u0015\u0014Q\f\u0002\u000b\u0007>tg.Z2uS>t\u0007\"\u0002-\n\u0001\u0004I\u0006\"\u00028\n\u0001\u0004y\u0007BBA\u0013\u0013\u0001\u0007\u0001\u0006C\u0004\u0002*%\u0001\r!a\u0011\u0002\u0015UtGn\\1e\t\u0006$\u0018\r\u0006\u0007\u0002D\u0005M\u0014QOA<\u0003w\ny\bC\u0004\u0002\b)\u0001\r!!\u0003\t\u000baS\u0001\u0019A-\t\r\u0005e$\u00021\u0001M\u0003\u001d!X-\u001c9ESJDa!! \u000b\u0001\u0004a\u0015A\u0003;f[B4uN]7bi\"1\u0011\u0011\u0011\u0006A\u00021\u000b!B\\;mYN#(/\u001b8h\u00039\u0019\u0018M^3U_J+Gm\u001d5jMR$\"\"a\u0014\u0002\b\u0006%\u00151RAK\u0011\u001d\t9a\u0003a\u0001\u0003\u0013AQ\u0001W\u0006A\u0002eCq!!$\f\u0001\u0004\ty)\u0001\u0005tCZ,Wj\u001c3f!\u0011\tY!!%\n\u0007\u0005M\u0015N\u0001\u0005TCZ,Wj\u001c3f\u0011\u0015q7\u00021\u0001p\u0001")
public class RedshiftWriter {
    private final JDBCWrapper jdbcWrapper;
    private final Function1<AWSCredentialsProvider, AmazonS3Client> s3ClientFactory;
    private final Logger log;

    private Logger log() {
        return this.log;
    }

    public String createTableSql(Dataset<Row> data, Parameters.MergedParameters params) {
        String string;
        String string2;
        String schemaSql = this.jdbcWrapper.schemaString(data.schema());
        Option<String> option = params.distStyle();
        if (option instanceof Some) {
            Some some = (Some)option;
            String style = (String)some.value();
            string2 = new StringBuilder(10).append("DISTSTYLE ").append(style).toString();
        } else if (None$.MODULE$.equals(option)) {
            string2 = "";
        } else {
            throw new MatchError(option);
        }
        String distStyleDef = string2;
        Option<String> option2 = params.distKey();
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String key = (String)some.value();
            string = new StringBuilder(10).append("DISTKEY (").append(key).append(")").toString();
        } else if (None$.MODULE$.equals(option2)) {
            string = "";
        } else {
            throw new MatchError(option2);
        }
        String distKeyDef = string;
        String sortKeyDef = (String)params.sortKeySpec().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        TableName table = (TableName)params.table().get();
        return new StringBuilder(33).append("CREATE TABLE IF NOT EXISTS ").append(table).append(" (").append(schemaSql).append(") ").append(distStyleDef).append(" ").append(distKeyDef).append(" ").append(sortKeyDef).toString();
    }

    private String copySql(SQLContext sqlContext, StructType schema, Parameters.MergedParameters params, AWSCredentialsProvider creds, String manifestUrl) {
        String string;
        String credsString = AWSCredentialsUtils$.MODULE$.getRedshiftCredentialsString(params, creds.getCredentials());
        String fixedUrl = Utils$.MODULE$.fixS3Url(manifestUrl);
        String string2 = params.tempFormat();
        if ("AVRO".equals(string2)) {
            string = "AVRO 'auto'";
        } else {
            String string3 = string2;
            String string4 = "CSV";
            if (string3 == null ? string4 != null : !string3.equals(string4)) {
                String string5 = string2;
                String string6 = "CSV GZIP";
                if (string5 != null ? !string5.equals(string6) : string6 != null) {
                    throw new MatchError((Object)string2);
                }
            }
            string = new StringBuilder(11).append(string2).append(" NULL AS '").append(params.nullString()).append("'").toString();
        }
        String format = string;
        String columns = params.includeColumnList() ? new StringBuilder(3).append("(").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fieldNames())).map((Function1 & Serializable & scala.Serializable)name -> new StringBuilder(2).append("\"").append((String)name).append("\"").toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",")).append(") ").toString() : "";
        return new StringBuilder(49).append("COPY ").append(params.table().get()).append(" ").append(columns).append("FROM '").append(fixedUrl).append("' CREDENTIALS '").append(credsString).append("' FORMAT AS ").append(format).append(" manifest ").append(params.extraCopyOptions()).toString();
    }

    public List<String> commentActions(Option<String> tableComment, StructType schema) {
        return (List)((List)tableComment.toList().map((Function1 & Serializable & scala.Serializable)desc -> new StringBuilder(25).append("COMMENT ON TABLE %s IS '").append(desc.replace("'", "''")).append("'").toString(), List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).withFilter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)RedshiftWriter.$anonfun$commentActions$2(f))).map((Function1 & Serializable & scala.Serializable)f -> new StringBuilder(29).append("COMMENT ON COLUMN %s.\"").append(f.name().replace("\"", "\\\"")).append("\"").append(" IS '").append(f.metadata().getString("description").replace("'", "''")).append("'").toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))), List$.MODULE$.canBuildFrom());
    }

    private void doRedshiftLoad(Connection conn, Dataset<Row> data, Parameters.MergedParameters params, AWSCredentialsProvider creds, Option<String> manifestUrl2) {
        String createStatement = this.createTableSql(data, params);
        this.log().info(createStatement);
        this.jdbcWrapper.executeInterruptibly(conn.prepareStatement(createStatement));
        List preActions = (List)this.commentActions(params.description(), data.schema()).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])params.preActions())), List$.MODULE$.canBuildFrom());
        preActions.foreach((Function1 & Serializable & scala.Serializable)action -> BoxesRunTime.boxToBoolean((boolean)RedshiftWriter.$anonfun$doRedshiftLoad$1(this, params, conn, action)));
        manifestUrl2.foreach((Function1 & Serializable & scala.Serializable)manifestUrl -> BoxesRunTime.boxToBoolean((boolean)RedshiftWriter.$anonfun$doRedshiftLoad$2(this, data, params, creds, conn, manifestUrl)));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])params.postActions())).foreach((Function1 & Serializable & scala.Serializable)action -> BoxesRunTime.boxToBoolean((boolean)RedshiftWriter.$anonfun$doRedshiftLoad$8(this, params, conn, action)));
    }

    private Option<String> unloadData(SQLContext sqlContext, Dataset<Row> data, String tempDir, String tempFormat, String nullString) {
        None$ none$;
        DataFrameWriter dataFrameWriter;
        Function1[] conversionFunctions = (Function1[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])data.schema().fields())).map((Function1 & Serializable & scala.Serializable)field -> {
            Function1 & Serializable & scala.Serializable intersect;
            DataType dataType = field.dataType();
            if (dataType instanceof DecimalType) {
                intersect = (Function1 & Serializable & scala.Serializable)v -> v == null ? null : v.toString();
            } else if (DateType$.MODULE$.equals(dataType)) {
                SimpleDateFormat dateFormat = Conversions$.MODULE$.createRedshiftDateFormat();
                intersect = (Function1 & Serializable & scala.Serializable)v -> v == null ? null : dateFormat.format((Date)v);
            } else if (TimestampType$.MODULE$.equals(dataType)) {
                SimpleDateFormat timestampFormat = Conversions$.MODULE$.createRedshiftTimestampFormat();
                intersect = (Function1 & Serializable & scala.Serializable)v -> v == null ? null : timestampFormat.format((Timestamp)v);
            } else {
                intersect = (Function1 & Serializable & scala.Serializable)v -> v;
            }
            return intersect;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Function1.class)));
        SetAccumulator nonEmptyPartitions = new SetAccumulator();
        sqlContext.sparkContext().register(nonEmptyPartitions);
        RDD convertedRows = data.rdd().mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            block0: {
                if (!iter.hasNext()) break block0;
                nonEmptyPartitions.add(BoxesRunTime.boxToInteger((int)TaskContext$.MODULE$.get().partitionId()));
            }
            return iter.map((Function1 & Serializable & scala.Serializable)row -> {
                Object[] convertedValues = new Object[conversionFunctions.length];
                for (int i = 0; i < conversionFunctions.length; ++i) {
                    convertedValues[i] = conversionFunctions[i].apply(row.apply(i));
                }
                return Row$.MODULE$.fromSeq((Seq)Predef$.MODULE$.genericWrapArray((Object)convertedValues));
            });
        }, data.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(Row.class));
        StructType schemaWithLowercaseColumnNames = StructType$.MODULE$.apply((Seq)data.schema().map((Function1 & Serializable & scala.Serializable)f -> f.copy(f.name().toLowerCase(), f.copy$default$2(), f.copy$default$3(), f.copy$default$4()), Seq$.MODULE$.canBuildFrom()));
        if (((TraversableOnce)schemaWithLowercaseColumnNames.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.name(), Seq$.MODULE$.canBuildFrom())).toSet().size() != data.schema().size()) {
            throw new IllegalArgumentException(new StringBuilder(113).append("Cannot save table to Redshift because two or more column names would be identical after conversion to lowercase: ").append(((TraversableOnce)data.schema().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.name(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).toString());
        }
        StructType convertedSchema = StructType$.MODULE$.apply((Seq)schemaWithLowercaseColumnNames.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            StructField structField = x0$1;
            if (structField != null) {
                String name = structField.name();
                boolean nullable = structField.nullable();
                Metadata meta = structField.metadata();
                if (structField.dataType() instanceof DecimalType) {
                    return new StructField(name, (DataType)StringType$.MODULE$, nullable, meta);
                }
            }
            if (structField != null) {
                String name = structField.name();
                DataType dataType = structField.dataType();
                boolean nullable = structField.nullable();
                Metadata meta = structField.metadata();
                if (DateType$.MODULE$.equals(dataType)) {
                    return new StructField(name, (DataType)StringType$.MODULE$, nullable, meta);
                }
            }
            if (structField == null) return structField;
            String name = structField.name();
            DataType dataType = structField.dataType();
            boolean nullable = structField.nullable();
            Metadata meta = structField.metadata();
            if (!TimestampType$.MODULE$.equals(dataType)) return structField;
            return new StructField(name, (DataType)StringType$.MODULE$, nullable, meta);
        }, Seq$.MODULE$.canBuildFrom()));
        DataFrameWriter writer = sqlContext.createDataFrame(convertedRows, convertedSchema).write();
        String string = tempFormat;
        if ("AVRO".equals(string)) {
            dataFrameWriter = writer.format("avro");
        } else if ("CSV".equals(string)) {
            dataFrameWriter = writer.format("csv").option("escape", "\"").option("nullValue", nullString);
        } else if ("CSV GZIP".equals(string)) {
            dataFrameWriter = writer.format("csv").option("escape", "\"").option("nullValue", nullString).option("compression", "gzip");
        } else {
            throw new MatchError((Object)string);
        }
        dataFrameWriter.save(tempDir);
        if (nonEmptyPartitions.value().isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            FileSystem fs = FileSystem.get((URI)URI.create(tempDir), (Configuration)sqlContext.sparkContext().hadoopConfiguration());
            Regex partitionIdRegex = new StringOps(Predef$.MODULE$.augmentString("^part-(?:r-)?(\\d+)[^\\d+].*$")).r();
            Set nonEmptyPartitionIds = nonEmptyPartitions.value().toSet();
            Seq filesToLoad = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(new Path(tempDir)))).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getPath().getName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).collect((PartialFunction)new scala.Serializable(null, partitionIdRegex, nonEmptyPartitionIds){
                public static final long serialVersionUID = 0L;
                private final Regex partitionIdRegex$1;
                private final Set nonEmptyPartitionIds$1;

                public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    String id;
                    A1 A1 = x1;
                    Option option = this.partitionIdRegex$1.unapplySeq(A1);
                    Object object = !option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0 && this.nonEmptyPartitionIds$1.contains((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(id = (String)((LinearSeqOptimized)option.get()).apply(0))).toInt())) ? A1 : function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(String x1) {
                    String id;
                    String string = x1;
                    Option option = this.partitionIdRegex$1.unapplySeq((CharSequence)string);
                    boolean bl = !option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0 && this.nonEmptyPartitionIds$1.contains((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(id = (String)((LinearSeqOptimized)option.get()).apply(0))).toInt()));
                    return bl;
                }
                {
                    this.partitionIdRegex$1 = partitionIdRegex$1;
                    this.nonEmptyPartitionIds$1 = nonEmptyPartitionIds$1;
                }
            }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
            String sanitizedTempDir = new StringOps(Predef$.MODULE$.augmentString(Utils$.MODULE$.fixS3Url(Utils$.MODULE$.removeCredentialsFromURI(URI.create(tempDir)).toString()))).stripSuffix("/");
            Seq manifestEntries = (Seq)filesToLoad.map((Function1 & Serializable & scala.Serializable)file -> new StringBuilder(29).append("{\"url\":\"").append(sanitizedTempDir).append("/").append((String)file).append("\", \"mandatory\":true}").toString(), Seq$.MODULE$.canBuildFrom());
            String manifest = new StringBuilder(15).append("{\"entries\": [").append(manifestEntries.mkString(",\n")).append("]}").toString();
            String manifestPath = new StringBuilder(14).append(sanitizedTempDir).append("/manifest.json").toString();
            try (FSDataOutputStream fsDataOut = fs.create(new Path(manifestPath));){
                fsDataOut.write(manifest.getBytes("utf-8"));
            }
            none$ = new Some((Object)manifestPath);
        }
        return none$;
    }

    public void saveToRedshift(SQLContext sqlContext, Dataset<Row> data, SaveMode saveMode, Parameters.MergedParameters params) {
        if (params.table().isEmpty()) {
            throw new IllegalArgumentException("For save operations you must specify a Redshift table name with the 'dbtable' parameter");
        }
        if (!params.useStagingTable()) {
            this.log().warn("Setting useStagingTable=false is deprecated; instead, we recommend that you drop the target table yourself. For more details on this deprecation, seehttps://github.com/databricks/spark-redshift/pull/157");
        }
        AWSCredentialsProvider creds = AWSCredentialsUtils$.MODULE$.load(params, sqlContext.sparkContext().hadoopConfiguration());
        Utils$.MODULE$.getRegionForRedshiftCluster(params.jdbcUrl()).foreach((Function1 & Serializable & scala.Serializable)redshiftRegion -> {
            RedshiftWriter.$anonfun$saveToRedshift$1(this, params, creds, redshiftRegion);
            return BoxedUnit.UNIT;
        });
        String string = params.tempFormat();
        String string2 = "AVRO";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])data.schema().fieldNames())).foreach((Function1 & Serializable & scala.Serializable)fieldName -> {
                RedshiftWriter.$anonfun$saveToRedshift$3(fieldName);
                return BoxedUnit.UNIT;
            });
        }
        Utils$.MODULE$.assertThatFileSystemIsNotS3BlockFileSystem(new URI(params.rootTempDir()), sqlContext.sparkContext().hadoopConfiguration());
        Utils$.MODULE$.checkThatBucketHasObjectLifecycleConfiguration(params.rootTempDir(), (AmazonS3Client)this.s3ClientFactory.apply((Object)creds));
        Option<String> manifestUrl = this.unloadData(sqlContext, data, params.createPerQueryTempDir(), params.tempFormat(), params.nullString());
        conn.setAutoCommit(false);
        try (Connection conn = this.jdbcWrapper.getConnector(params.jdbcDriver(), params.jdbcUrl(), params.credentials());){
            try {
                TableName table = (TableName)params.table().get();
                SaveMode saveMode2 = saveMode;
                SaveMode saveMode3 = SaveMode.Overwrite;
                if (!(saveMode2 != null ? !saveMode2.equals(saveMode3) : saveMode3 != null)) {
                    this.jdbcWrapper.executeInterruptibly(conn.prepareStatement(new StringBuilder(22).append("DROP TABLE IF EXISTS ").append(table).append(";").toString()));
                    if (!params.useStagingTable()) {
                        conn.commit();
                    }
                }
                this.log().info(new StringBuilder(30).append("Loading new Redshift data to: ").append(table).toString());
                this.doRedshiftLoad(conn, data, params, creds, manifestUrl);
                conn.commit();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e;
                    block15: {
                        e = (Throwable)option.get();
                        try {
                            this.log().error("Exception thrown during Redshift load; will roll back transaction", e);
                            conn.rollback();
                        }
                        catch (Throwable throwable3) {
                            Throwable throwable4 = throwable3;
                            Option option2 = NonFatal$.MODULE$.unapply(throwable4);
                            if (!option2.isEmpty()) {
                                Throwable e2 = (Throwable)option2.get();
                                this.log().error("Exception while rolling back transaction", e2);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block15;
                            }
                            throw throwable3;
                        }
                    }
                    throw e;
                }
                throw throwable;
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$commentActions$2(StructField f) {
        return f.metadata().contains("description");
    }

    public static final /* synthetic */ boolean $anonfun$doRedshiftLoad$1(RedshiftWriter $this, Parameters.MergedParameters params$1, Connection conn$1, String action) {
        String actionSql = action.contains("%s") ? new StringOps(Predef$.MODULE$.augmentString(action)).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params$1.table().get()})) : action;
        $this.log().info(new StringBuilder(21).append("Executing preAction: ").append(actionSql).toString());
        return $this.jdbcWrapper.executeInterruptibly(conn$1.prepareStatement(actionSql));
    }

    public static final /* synthetic */ boolean $anonfun$doRedshiftLoad$4(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$doRedshiftLoad$2(RedshiftWriter $this, Dataset data$1, Parameters.MergedParameters params$1, AWSCredentialsProvider creds$1, Connection conn$1, String manifestUrl) {
        boolean bl;
        String copyStatement = $this.copySql(data$1.sqlContext(), data$1.schema(), params$1, creds$1, manifestUrl);
        $this.log().info(copyStatement);
        try {
            bl = $this.jdbcWrapper.executeInterruptibly(conn$1.prepareStatement(copyStatement));
        }
        catch (SQLException e) {
            None$ none$;
            $this.log().error("SQLException thrown while running COPY query; will attempt to retrieve more information by querying the STL_LOAD_ERRORS table", (Throwable)e);
            conn$1.rollback();
            String errorLookupQuery = new StringOps(Predef$.MODULE$.augmentString("\n              | SELECT *\n              | FROM stl_load_errors\n              | WHERE query = pg_last_query_id()\n            ")).stripMargin();
            try {
                ResultSet results = $this.jdbcWrapper.executeQueryInterruptibly(conn$1.prepareStatement(errorLookupQuery));
                if (results.next()) {
                    int errCode = results.getInt("err_code");
                    String errReason = results.getString("err_reason").trim();
                    String columnLength = (String)Option$.MODULE$.apply((Object)results.getString("col_length")).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.trim()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)RedshiftWriter.$anonfun$doRedshiftLoad$4(x$2))).map((Function1 & Serializable & scala.Serializable)n -> new StringBuilder(2).append("(").append((String)n).append(")").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                    String exceptionMessage = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(260).append("\n                   |Error (code ").append(errCode).append(") while loading data into Redshift: \"").append(errReason).append("\"\n                   |Table name: ").append(params$1.table().get()).append("\n                   |Column name: ").append(results.getString("colname").trim()).append("\n                   |Column type: ").append(results.getString("type").trim()).append(columnLength).append("\n                   |Raw line: ").append(results.getString("raw_line")).append("\n                   |Raw field value: ").append(results.getString("raw_field_value")).append("\n                  ").toString())).stripMargin();
                    none$ = new Some((Object)new SQLException(exceptionMessage, e));
                } else {
                    none$ = None$.MODULE$;
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e2 = (Throwable)option.get();
                $this.log().error("Error occurred while querying STL_LOAD_ERRORS", e2);
                None$ none$2 = None$.MODULE$;
                none$ = none$2;
            }
            None$ detailedException = none$;
            throw (Throwable)detailedException.getOrElse((Function0 & Serializable & scala.Serializable)() -> e);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$doRedshiftLoad$8(RedshiftWriter $this, Parameters.MergedParameters params$1, Connection conn$1, String action) {
        String actionSql = action.contains("%s") ? new StringOps(Predef$.MODULE$.augmentString(action)).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{params$1.table().get()})) : action;
        $this.log().info(new StringBuilder(22).append("Executing postAction: ").append(actionSql).toString());
        return $this.jdbcWrapper.executeInterruptibly(conn$1.prepareStatement(actionSql));
    }

    public static final /* synthetic */ void $anonfun$saveToRedshift$2(RedshiftWriter $this, Parameters.MergedParameters params$2, String redshiftRegion$1, String s3Region) {
        block0: {
            boolean regionIsSetInExtraCopyOptions = params$2.extraCopyOptions().contains(s3Region) && params$2.extraCopyOptions().contains("region");
            String string = redshiftRegion$1;
            String string2 = s3Region;
            if (!(string == null ? string2 != null : !string.equals(string2)) || regionIsSetInExtraCopyOptions) break block0;
            $this.log().error(new StringBuilder(243).append("The Redshift cluster and S3 bucket are in different regions ").append("(").append(redshiftRegion$1).append(" and ").append(s3Region).append(", respectively). In order to perform this cross-region ").append("write, you must add \"region '").append(s3Region).append("'\" to the extracopyoptions parameter. ").append("For more details on cross-region usage, see the README.").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$saveToRedshift$1(RedshiftWriter $this, Parameters.MergedParameters params$2, AWSCredentialsProvider creds$2, String redshiftRegion) {
        Utils$.MODULE$.getRegionForS3Bucket(params$2.rootTempDir(), (AmazonS3Client)$this.s3ClientFactory.apply((Object)creds$2)).foreach((Function1 & Serializable & scala.Serializable)s3Region -> {
            RedshiftWriter.$anonfun$saveToRedshift$2($this, params$2, redshiftRegion, s3Region);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$saveToRedshift$4(char c) {
        return RichChar$.MODULE$.isLetterOrDigit$extension(Predef$.MODULE$.charWrapper(c)) || c == '_';
    }

    public static final /* synthetic */ void $anonfun$saveToRedshift$3(String fieldName) {
        boolean isValid;
        char firstChar = fieldName.charAt(0);
        boolean bl = isValid = (RichChar$.MODULE$.isLetter$extension(Predef$.MODULE$.charWrapper(firstChar)) || firstChar == '_') && new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(fieldName)).tail())).forall((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)RedshiftWriter.$anonfun$saveToRedshift$4(BoxesRunTime.unboxToChar((Object)c))));
        if (!isValid) {
            throw new IllegalArgumentException(new StringBuilder(182).append("The field name '").append(fieldName).append("' is not supported when using the Avro tempformat. ").append("Try using the CSV tempformat  instead. For more details, see ").append("https://github.com/databricks/spark-redshift/issues/84").toString());
        }
    }

    public RedshiftWriter(JDBCWrapper jdbcWrapper, Function1<AWSCredentialsProvider, AmazonS3Client> s3ClientFactory) {
        this.jdbcWrapper = jdbcWrapper;
        this.s3ClientFactory = s3ClientFactory;
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

