/*
 * Decompiled with CFR 0.152.
 */
package io.github.spark_redshift_community.spark.redshift;

import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3URI;
import com.amazonaws.services.s3.model.BucketLifecycleConfiguration;
import java.io.Serializable;
import java.net.URI;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class Utils$ {
    public static Utils$ MODULE$;
    private final Logger log;
    private String lastTempPathGenerated;

    static {
        new Utils$();
    }

    private Logger log() {
        return this.log;
    }

    public Class<?> classForName(String className) {
        ClassLoader classLoader = (ClassLoader)Option$.MODULE$.apply((Object)Thread.currentThread().getContextClassLoader()).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.getClass().getClassLoader());
        return Class.forName(className, true, classLoader);
    }

    public String joinUrls(String a, String b) {
        return new StringBuilder(2).append(new StringOps(Predef$.MODULE$.augmentString(a)).stripSuffix("/")).append("/").append(new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(b)).stripPrefix("/"))).stripSuffix("/")).append("/").toString();
    }

    public String fixS3Url(String url) {
        return url.replaceAll("s3[an]://", "s3://");
    }

    public AmazonS3URI createS3URI(String url) {
        AmazonS3URI amazonS3URI;
        try {
            amazonS3URI = new AmazonS3URI(url);
        }
        catch (Throwable throwable) {
            IllegalArgumentException illegalArgumentException;
            Throwable throwable2 = throwable;
            if (!(throwable2 instanceof IllegalArgumentException) || !(illegalArgumentException = (IllegalArgumentException)throwable2).getMessage().startsWith("Invalid S3 URI: hostname does not appear to be a valid S3 endpoint")) {
                throw throwable;
            }
            AmazonS3URI amazonS3URI2 = new AmazonS3URI(this.addEndpointToUrl(url, this.addEndpointToUrl$default$2()));
            amazonS3URI = amazonS3URI2;
        }
        return amazonS3URI;
    }

    public String addEndpointToUrl(String url, String domain) {
        URI uri = new URI(url);
        String hostWithEndpoint = new StringBuilder(1).append(uri.getHost()).append(".").append(domain).toString();
        return new URI(uri.getScheme(), uri.getUserInfo(), hostWithEndpoint, uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment()).toString();
    }

    public String addEndpointToUrl$default$2() {
        return "s3.amazonaws.com";
    }

    public URI removeCredentialsFromURI(URI uri) {
        return new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
    }

    public String lastTempPathGenerated() {
        return this.lastTempPathGenerated;
    }

    public void lastTempPathGenerated_$eq(String x$1) {
        this.lastTempPathGenerated = x$1;
    }

    public String makeTempPath(String tempRoot) {
        this.lastTempPathGenerated_$eq(this.joinUrls(tempRoot, UUID.randomUUID().toString()));
        return this.lastTempPathGenerated();
    }

    public void checkThatBucketHasObjectLifecycleConfiguration(String tempDir, AmazonS3Client s3Client) {
        try {
            AmazonS3URI s3URI = this.createS3URI(this.fixS3Url(tempDir));
            String bucket = s3URI.getBucket();
            Predef$.MODULE$.assert(bucket != null, (Function0 & Serializable & scala.Serializable)() -> "Could not get bucket from S3 URI");
            String key = (String)Option$.MODULE$.apply((Object)s3URI.getKey()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
            Seq rules = (Seq)Option$.MODULE$.apply((Object)s3Client.getBucketLifecycleConfiguration(bucket)).map((Function1 & Serializable & scala.Serializable)x$1 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$1.getRules()).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
            boolean hasMatchingBucketLifecycleRule = rules.exists((Function1 & Serializable & scala.Serializable)rule -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$checkThatBucketHasObjectLifecycleConfiguration$5(key, rule)));
            if (!hasMatchingBucketLifecycleRule) {
                this.log().warn(new StringBuilder(346).append("The S3 bucket ").append(bucket).append(" does not have an object lifecycle configuration to ").append("ensure cleanup of temporary files. Consider configuring `tempdir` to point to a ").append("bucket with an object lifecycle policy that automatically deletes files after an ").append("expiration period. For more information, see ").append("https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html").toString());
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.log().warn("An error occurred while trying to read the S3 bucket lifecycle configuration", e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    public void assertThatFileSystemIsNotS3BlockFileSystem(URI uri, Configuration hadoopConfig) {
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)hadoopConfig);
        String string = fs.getClass().getCanonicalName();
        String string2 = "org.apache.hadoop.fs.s3.S3FileSystem";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new IllegalArgumentException("spark-redshift does not support the S3 Block FileSystem. Please reconfigure `tempdir` touse a s3n:// or s3a:// scheme.");
        }
    }

    public Option<String> getRegionForS3Bucket(String tempDir, AmazonS3Client s3Client) {
        None$ none$;
        try {
            AmazonS3URI s3URI = this.createS3URI(this.fixS3Url(tempDir));
            String bucket = s3URI.getBucket();
            Predef$.MODULE$.assert(bucket != null, (Function0 & Serializable & scala.Serializable)() -> "Could not get bucket from S3 URI");
            String string = s3Client.getBucketLocation(bucket);
            boolean bl = string == null ? true : "US".equals(string);
            String string2 = bl ? "us-east-1" : string;
            String region = string2;
            none$ = new Some((Object)region);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.log().warn("An error occurred while trying to determine the S3 bucket's region", e);
            None$ none$2 = None$.MODULE$;
            none$ = none$2;
        }
        return none$;
    }

    public Option<String> getRegionForRedshiftCluster(String url) {
        None$ none$;
        String string;
        Regex regionRegex = new StringOps(Predef$.MODULE$.augmentString(".*\\.([^.]+)\\.redshift\\.amazonaws\\.com.*")).r();
        Option option = regionRegex.unapplySeq((CharSequence)(string = url));
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            String region = (String)((LinearSeqOptimized)option.get()).apply(0);
            none$ = new Some((Object)region);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public static final /* synthetic */ boolean $anonfun$checkThatBucketHasObjectLifecycleConfiguration$5(String key$1, BucketLifecycleConfiguration.Rule rule) {
        String string = rule.getStatus();
        String string2 = "Enabled";
        return !(string != null ? !string.equals(string2) : string2 != null) && key$1.startsWith(rule.getPrefix());
    }

    private Utils$() {
        MODULE$ = this;
        this.log = LoggerFactory.getLogger(this.getClass());
        this.lastTempPathGenerated = null;
    }
}

