/*
 * Decompiled with CFR 0.152.
 */
package io.github.spark_redshift_community.spark.redshift;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3Client;
import io.github.spark_redshift_community.spark.redshift.DefaultJDBCWrapper$;
import io.github.spark_redshift_community.spark.redshift.JDBCWrapper;
import io.github.spark_redshift_community.spark.redshift.Parameters;
import io.github.spark_redshift_community.spark.redshift.Parameters$;
import io.github.spark_redshift_community.spark.redshift.RedshiftRelation;
import io.github.spark_redshift_community.spark.redshift.RedshiftWriter;
import io.github.spark_redshift_community.spark.redshift.TableName;
import java.io.Serializable;
import java.sql.Connection;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.CreatableRelationProvider;
import org.apache.spark.sql.sources.RelationProvider;
import org.apache.spark.sql.sources.SchemaRelationProvider;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005Mb\u0001\u0002\u0006\f\u0001YA\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\tk\u0001\u0011\t\u0011)A\u0005m!)1\n\u0001C\u0001\u0019\"9\u0001\u000b\u0001b\u0001\n\u0013\t\u0006B\u0002-\u0001A\u0003%!\u000bC\u0003L\u0001\u0011\u0005\u0011\fC\u0003[\u0001\u0011\u00053\fC\u0003[\u0001\u0011\u0005S\u000f\u0003\u0004[\u0001\u0011\u0005\u0013\u0011\u0001\u0002\u000e\t\u00164\u0017-\u001e7u'>,(oY3\u000b\u00051i\u0011\u0001\u0003:fIND\u0017N\u001a;\u000b\u00059y\u0011!B:qCJ\\'B\u0001\t\u0012\u0003a\u0019\b/\u0019:l?J,Gm\u001d5jMR|6m\\7nk:LG/\u001f\u0006\u0003%M\taaZ5uQV\u0014'\"\u0001\u000b\u0002\u0005%|7\u0001A\n\u0006\u0001]i\"&\f\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005yAS\"A\u0010\u000b\u0005\u0001\n\u0013aB:pkJ\u001cWm\u001d\u0006\u0003E\r\n1a]9m\u0015\tqAE\u0003\u0002&M\u00051\u0011\r]1dQ\u0016T\u0011aJ\u0001\u0004_J<\u0017BA\u0015 \u0005A\u0011V\r\\1uS>t\u0007K]8wS\u0012,'\u000f\u0005\u0002\u001fW%\u0011Af\b\u0002\u0017'\u000eDW-\\1SK2\fG/[8o!J|g/\u001b3feB\u0011aDL\u0005\u0003_}\u0011\u0011d\u0011:fCR\f'\r\\3SK2\fG/[8o!J|g/\u001b3fe\u0006Y!\u000e\u001a2d/J\f\u0007\u000f]3s!\t\u00114'D\u0001\f\u0013\t!4BA\u0006K\t\n\u001buK]1qa\u0016\u0014\u0018aD:4\u00072LWM\u001c;GC\u000e$xN]=\u0011\ta9\u0014hQ\u0005\u0003qe\u0011\u0011BR;oGRLwN\\\u0019\u0011\u0005i\nU\"A\u001e\u000b\u0005qj\u0014\u0001B1vi\"T!AP \u0002\u0013\u0005l\u0017M_8oC^\u001c(\"\u0001!\u0002\u0007\r|W.\u0003\u0002Cw\t1\u0012iV*De\u0016$WM\u001c;jC2\u001c\bK]8wS\u0012,'\u000f\u0005\u0002E\u00136\tQI\u0003\u0002G\u000f\u0006\u00111o\r\u0006\u0003\u0011v\n\u0001b]3sm&\u001cWm]\u0005\u0003\u0015\u0016\u0013a\"Q7bu>t7kM\"mS\u0016tG/\u0001\u0004=S:LGO\u0010\u000b\u0004\u001b:{\u0005C\u0001\u001a\u0001\u0011\u0015\u00014\u00011\u00012\u0011\u0015)4\u00011\u00017\u0003\rawnZ\u000b\u0002%B\u00111KV\u0007\u0002)*\u0011QKJ\u0001\u0006g24GG[\u0005\u0003/R\u0013a\u0001T8hO\u0016\u0014\u0018\u0001\u00027pO\u0002\"\u0012!T\u0001\u000fGJ,\u0017\r^3SK2\fG/[8o)\rav,\u001a\t\u0003=uK!AX\u0010\u0003\u0019\t\u000b7/\u001a*fY\u0006$\u0018n\u001c8\t\u000b\u0001<\u0001\u0019A1\u0002\u0015M\fHnQ8oi\u0016DH\u000f\u0005\u0002cG6\t\u0011%\u0003\u0002eC\tQ1+\u0015'D_:$X\r\u001f;\t\u000b\u0019<\u0001\u0019A4\u0002\u0015A\f'/Y7fi\u0016\u00148\u000f\u0005\u0003i_J\u0014hBA5n!\tQ\u0017$D\u0001l\u0015\taW#\u0001\u0004=e>|GOP\u0005\u0003]f\ta\u0001\u0015:fI\u00164\u0017B\u00019r\u0005\ri\u0015\r\u001d\u0006\u0003]f\u0001\"\u0001[:\n\u0005Q\f(AB*ue&tw\r\u0006\u0003]m^D\b\"\u00021\t\u0001\u0004\t\u0007\"\u00024\t\u0001\u00049\u0007\"B=\t\u0001\u0004Q\u0018AB:dQ\u0016l\u0017\r\u0005\u0002|}6\tAP\u0003\u0002~C\u0005)A/\u001f9fg&\u0011q\u0010 \u0002\u000b'R\u0014Xo\u0019;UsB,G#\u0003/\u0002\u0004\u0005\u0015\u0011qBA\t\u0011\u0015\u0001\u0017\u00021\u0001b\u0011\u001d\t9!\u0003a\u0001\u0003\u0013\t\u0001b]1wK6{G-\u001a\t\u0004E\u0006-\u0011bAA\u0007C\tA1+\u0019<f\u001b>$W\rC\u0003g\u0013\u0001\u0007q\rC\u0004\u0002\u0014%\u0001\r!!\u0006\u0002\t\u0011\fG/\u0019\t\u0005\u0003/\tiC\u0004\u0003\u0002\u001a\u0005%b\u0002BA\u000e\u0003OqA!!\b\u0002&9!\u0011qDA\u0012\u001d\rQ\u0017\u0011E\u0005\u0002O%\u0011QEJ\u0005\u0003\u001d\u0011J!AI\u0012\n\u0007\u0005-\u0012%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005=\u0012\u0011\u0007\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T1!a\u000b\"\u0001")
public class DefaultSource
implements RelationProvider,
SchemaRelationProvider,
CreatableRelationProvider {
    private final JDBCWrapper jdbcWrapper;
    private final Function1<AWSCredentialsProvider, AmazonS3Client> s3ClientFactory;
    private final Logger log;

    private Logger log() {
        return this.log;
    }

    public BaseRelation createRelation(SQLContext sqlContext, Map<String, String> parameters) {
        Parameters.MergedParameters params = Parameters$.MODULE$.mergeParameters(parameters);
        return new RedshiftRelation(this.jdbcWrapper, this.s3ClientFactory, params, (Option<StructType>)None$.MODULE$, sqlContext);
    }

    public BaseRelation createRelation(SQLContext sqlContext, Map<String, String> parameters, StructType schema) {
        Parameters.MergedParameters params = Parameters$.MODULE$.mergeParameters(parameters);
        return new RedshiftRelation(this.jdbcWrapper, this.s3ClientFactory, params, (Option<StructType>)new Some((Object)schema), sqlContext);
    }

    public BaseRelation createRelation(SQLContext sqlContext, SaveMode saveMode, Map<String, String> parameters, Dataset<Row> data) {
        block12: {
            Tuple2.mcZZ.sp sp2;
            Parameters.MergedParameters params = Parameters$.MODULE$.mergeParameters(parameters);
            TableName table = (TableName)params.table().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalArgumentException("For save operations you must specify a Redshift table name with the 'dbtable' parameter");
            });
            SaveMode saveMode2 = saveMode;
            if (SaveMode.Append.equals(saveMode2)) {
                sp2 = new Tuple2.mcZZ.sp(true, false);
            } else if (SaveMode.Overwrite.equals(saveMode2)) {
                sp2 = new Tuple2.mcZZ.sp(true, true);
            } else if (SaveMode.ErrorIfExists.equals(saveMode2)) {
                if (this.tableExists$1(params, table)) {
                    throw package$.MODULE$.error(new StringBuilder(57).append("Table ").append(table).append(" already exists! (SaveMode is set to ErrorIfExists)").toString());
                }
                sp2 = new Tuple2.mcZZ.sp(true, false);
            } else if (SaveMode.Ignore.equals(saveMode2)) {
                Tuple2.mcZZ.sp sp3;
                if (this.tableExists$1(params, table)) {
                    this.log().info(new StringBuilder(47).append("Table ").append(table).append(" already exists -- ignoring save request.").toString());
                    sp3 = new Tuple2.mcZZ.sp(false, false);
                } else {
                    sp3 = new Tuple2.mcZZ.sp(true, false);
                }
                sp2 = sp3;
            } else {
                throw new MatchError((Object)saveMode2);
            }
            Tuple2.mcZZ.sp sp4 = sp2;
            if (sp4 == null) {
                throw new MatchError((Object)sp4);
            }
            boolean doSave = sp4._1$mcZ$sp();
            boolean dropExisting = sp4._2$mcZ$sp();
            Tuple2.mcZZ.sp sp5 = new Tuple2.mcZZ.sp(doSave, dropExisting);
            Tuple2.mcZZ.sp sp6 = sp5;
            boolean doSave2 = sp6._1$mcZ$sp();
            boolean dropExisting2 = sp6._2$mcZ$sp();
            if (!doSave2) break block12;
            Map updatedParams = parameters.updated((Object)"overwrite", (Object)Boolean.toString(dropExisting2));
            new RedshiftWriter(this.jdbcWrapper, this.s3ClientFactory).saveToRedshift(sqlContext, data, saveMode, Parameters$.MODULE$.mergeParameters((Map<String, String>)updatedParams));
        }
        return this.createRelation(sqlContext, parameters);
    }

    private final boolean tableExists$1(Parameters.MergedParameters params$1, TableName table$1) {
        boolean bl;
        try (Connection conn = this.jdbcWrapper.getConnector(params$1.jdbcDriver(), params$1.jdbcUrl(), params$1.credentials());){
            bl = this.jdbcWrapper.tableExists(conn, table$1.toString());
        }
        return bl;
    }

    public DefaultSource(JDBCWrapper jdbcWrapper, Function1<AWSCredentialsProvider, AmazonS3Client> s3ClientFactory) {
        this.jdbcWrapper = jdbcWrapper;
        this.s3ClientFactory = s3ClientFactory;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    public DefaultSource() {
        this(DefaultJDBCWrapper$.MODULE$, (Function1<AWSCredentialsProvider, AmazonS3Client>)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final AmazonS3Client apply(AWSCredentialsProvider awsCredentials) {
                return new AmazonS3Client(awsCredentials);
            }
        });
    }
}

