/*
 * Decompiled with CFR 0.152.
 */
package com.github.sparsick.testcontainers.gitserver.http;

import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.sparsick.testcontainers.gitserver.http.BasicAuthenticationCredentials;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.images.builder.ImageFromDockerfile;
import org.testcontainers.images.builder.dockerfile.DockerfileBuilder;
import org.testcontainers.utility.DockerImageName;

public class GitHttpServerContainer
extends GenericContainer<GitHttpServerContainer> {
    private final String gitRepoName = "testRepo";
    private static final DockerImageName DEFAULT_DOCKER_IMAGE_NAME = DockerImageName.parse((String)"rockstorm/git-server");
    private final BasicAuthenticationCredentials basicAuthenticationCredentials;

    public GitHttpServerContainer(DockerImageName dockerImageName) {
        this(dockerImageName, null);
    }

    public GitHttpServerContainer(DockerImageName dockerImageName, BasicAuthenticationCredentials basicAuthenticationCredentials) {
        super((Future)((ImageFromDockerfile)new ImageFromDockerfile().withFileFromClasspath("http-config/nginx.conf", "http-config/nginx.conf")).withDockerfileFromBuilder(GitHttpServerContainer.dockerfileBuilder(dockerImageName, basicAuthenticationCredentials)));
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_DOCKER_IMAGE_NAME});
        if ("2.38".compareTo(dockerImageName.getVersionPart()) <= 0) {
            ((GitHttpServerContainer)this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Container configuration completed.*", (int)1))).addExposedPorts(new int[]{80});
        } else {
            this.withExposedPorts(new Integer[]{80});
        }
        this.basicAuthenticationCredentials = basicAuthenticationCredentials;
    }

    @NotNull
    private static Consumer<DockerfileBuilder> dockerfileBuilder(DockerImageName dockerImageName, BasicAuthenticationCredentials basicAuthenticationCredentials) {
        return builder -> {
            DockerfileBuilder tempBuilder = (DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)builder.from(dockerImageName.toString())).run("apk add --update nginx && " + GitHttpServerContainer.checkUpdateGit(dockerImageName) + "apk add --update fcgiwrap && apk add --update spawn-fcgi && " + GitHttpServerContainer.checkIfOpensslIsNeeded(basicAuthenticationCredentials) + "rm -rf /var/cache/apk/*")).copy("./http-config/nginx.conf", "/etc/nginx/nginx.conf");
            if (basicAuthenticationCredentials != null) {
                tempBuilder.run(new String[]{"sh", "-c", "echo \"" + basicAuthenticationCredentials.getUsername() + ":$(openssl passwd -apr1 " + basicAuthenticationCredentials.getPassword() + ")\" > /etc/nginx/.htpasswd"});
                tempBuilder.run(new String[]{"sh", "-c", "sed -i -e 's/#auth_basic/auth_basic/g' /etc/nginx/nginx.conf"});
            }
            ((DockerfileBuilder)tempBuilder.cmd("spawn-fcgi -s /run/fcgi.sock -- /usr/bin/fcgiwrap -f &&     nginx -g \"daemon off;\"")).build();
        };
    }

    @NotNull
    private static String checkIfOpensslIsNeeded(BasicAuthenticationCredentials basicAuthenticationCredentials) {
        String enableOpenssl = basicAuthenticationCredentials != null ? "apk add --update openssl && " : "";
        return enableOpenssl;
    }

    @NotNull
    private static String checkUpdateGit(DockerImageName dockerImageName) {
        String updateGit = "2.36".compareTo(dockerImageName.getVersionPart()) == 0 ? "apk add --update git=2.36.6-r0 git-daemon=2.36.6-r0 && " : ("2.34".compareTo(dockerImageName.getVersionPart()) == 0 ? "apk add --update git=2.34.8-r0 git-daemon=2.34.8-r0 && " : "apk add --update git git-daemon && ");
        return updateGit;
    }

    public URI getGitRepoURIAsHttp() {
        return URI.create("http://" + this.getHost() + ":" + this.getMappedPort(80) + "/git/testRepo");
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        super.containerIsStarted(containerInfo);
        this.configureGitRepository();
    }

    private void configureGitRepository() {
        try {
            String gitRepoPath = String.format("/srv/git/%s.git", "testRepo");
            this.execInContainer(new String[]{"mkdir", "-p", gitRepoPath});
            this.execInContainer(new String[]{"git", "init", "--bare", gitRepoPath});
            this.execInContainer(new String[]{"sh", "-c", "echo '[http]' >> " + gitRepoPath + "/config"});
            this.execInContainer(new String[]{"sh", "-c", "echo '        receivepack = true' >> " + gitRepoPath + "/config"});
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("Configure Git repository failed", e);
        }
    }

    public BasicAuthenticationCredentials getBasicAuthCredentials() {
        return this.basicAuthenticationCredentials;
    }
}

