/*
 * Decompiled with CFR 0.152.
 */
package com.github.sparsick.testcontainers.gitserver.plain;

import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.sparsick.testcontainers.gitserver.plain.SshHostKey;
import com.github.sparsick.testcontainers.gitserver.plain.SshIdentity;
import java.io.IOException;
import java.net.URI;
import java.util.Base64;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public class GitServerContainer
extends GenericContainer<GitServerContainer> {
    private static final String GIT_PASSWORD_KEY = "GIT_PASSWORD";
    private static DockerImageName DEFAULT_DOCKER_IMAGE_NAME = DockerImageName.parse((String)"rockstorm/git-server");
    private String gitRepoName = "testRepo";
    private String pathToExistingRepo;
    private SshIdentity sshClientIdentity;
    private SshHostKey hostKey;

    public GitServerContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_DOCKER_IMAGE_NAME});
        if ("2.38".compareTo(dockerImageName.getVersionPart()) <= 0) {
            ((GitServerContainer)((GitServerContainer)this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Container configuration completed.*", (int)1))).waitingFor((WaitStrategy)Wait.forListeningPorts((int[])new int[]{22}))).addExposedPorts(new int[]{22});
        } else {
            ((GitServerContainer)this.waitingFor((WaitStrategy)Wait.forListeningPorts((int[])new int[]{22}))).addExposedPorts(new int[]{22});
        }
        this.withCommand(new String[]{"/usr/sbin/sshd", "-D", "-e"});
    }

    public GitServerContainer withGitPassword(String password) {
        this.withEnv(GIT_PASSWORD_KEY, password);
        return this;
    }

    public GitServerContainer withGitRepo(String gitRepoName) {
        this.gitRepoName = gitRepoName;
        return this;
    }

    public GitServerContainer withSshKeyAuth() {
        try {
            this.sshClientIdentity = new SshIdentity(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("id_client").readAllBytes(), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("id_client.pub").readAllBytes(), new byte[0]);
            this.withClasspathResourceMapping("id_client.pub", "/home/git/.ssh/authorized_keys", BindMode.READ_ONLY);
            this.withClasspathResourceMapping("sshd_config", "/etc/ssh/sshd_config", BindMode.READ_ONLY);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public GitServerContainer withCopyExistingGitRepoToContainer(String pathtoExistingRepo) {
        this.pathToExistingRepo = pathtoExistingRepo;
        return this;
    }

    public URI getGitRepoURIAsSSH() {
        return URI.create("ssh://git@" + this.getHost() + ":" + this.getMappedPort(22) + "/srv/git/" + this.gitRepoName + ".git");
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        super.containerIsStarted(containerInfo);
        this.configureGitRepository();
        this.collectHostKeyInformation();
        this.fixFilePermissions();
    }

    private void fixFilePermissions() {
        try {
            this.execInContainer(new String[]{"chmod", "600", "/home/git/.ssh/authorized_keys"});
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("Could not fix file permissions on /home/git/.ssh/authorized_keys", e);
        }
    }

    private void collectHostKeyInformation() {
        try {
            Container.ExecResult result = this.execInContainer(new String[]{"cat", "/etc/ssh/ssh_host_ecdsa_key.pub"});
            String[] catResult = result.getStdout().split(" ");
            this.hostKey = new SshHostKey(this.getHost(), Base64.getDecoder().decode(catResult[1]));
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("Could not collect host key information", e);
        }
    }

    private void configureGitRepository() {
        try {
            String gitRepoPath = String.format("/srv/git/%s.git", this.gitRepoName);
            if (this.pathToExistingRepo != null) {
                this.copyFileToContainer(MountableFile.forHostPath((String)(this.pathToExistingRepo + "/.git")), gitRepoPath);
                this.execInContainer(new String[]{"git", "config", "--bool", "core.bare", "true", gitRepoPath});
                this.execInContainer(new String[]{"chown", "-R", "git:git", "/srv"});
            } else {
                this.execInContainer(new String[]{"mkdir", "-p", gitRepoPath});
                this.execInContainer(new String[]{"git", "init", "--bare", gitRepoPath});
                this.execInContainer(new String[]{"chown", "-R", "git:git", "/srv"});
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("Configure Git repository failed", e);
        }
    }

    public String getGitPassword() {
        String password = (String)this.getEnvMap().get(GIT_PASSWORD_KEY);
        return password != null ? password : "12345";
    }

    public SshIdentity getSshClientIdentity() {
        return this.sshClientIdentity;
    }

    public SshHostKey getHostKey() {
        return this.hostKey;
    }
}

