/*
 * Decompiled with CFR 0.152.
 */
package io.github.springboot.httpclient.actuator;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.codahale.metrics.httpclient.HttpClientMetricNameStrategy;
import io.github.springboot.httpclient.core.internal.ChainableHttpRequestExecutor;
import io.github.springboot.httpclient.core.internal.HttpRequestExecutorChain;
import java.io.IOException;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainableInstrumentedHttpRequestExecutor
implements ChainableHttpRequestExecutor {
    private static final Logger log = LoggerFactory.getLogger(ChainableInstrumentedHttpRequestExecutor.class);
    private final MetricRegistry registry;
    private final HttpClientMetricNameStrategy metricNameStrategy;
    private final String name;

    public ChainableInstrumentedHttpRequestExecutor(MetricRegistry registry, HttpClientMetricNameStrategy metricNameStrategy) {
        this(registry, metricNameStrategy, null);
    }

    public ChainableInstrumentedHttpRequestExecutor(MetricRegistry registry, HttpClientMetricNameStrategy metricNameStrategy, String name) {
        this.registry = registry;
        this.name = name;
        this.metricNameStrategy = metricNameStrategy;
    }

    public HttpResponse doExecute(HttpRequest request, HttpClientConnection conn, HttpContext context, HttpRequestExecutorChain chain) throws HttpException, IOException {
        Timer.Context timerContext = this.timer(request).time();
        try {
            log.debug("before ChainableInstrumentedHttpRequestExecutor.doExecute");
            HttpResponse httpResponse = chain.doExecute(request, conn, context);
            return httpResponse;
        }
        catch (IOException | HttpException e) {
            this.meter((Exception)e).mark();
            throw e;
        }
        finally {
            log.debug("after ChainableInstrumentedHttpRequestExecutor.doExecute");
            timerContext.stop();
        }
    }

    private Timer timer(HttpRequest request) {
        return this.registry.timer(this.metricNameStrategy.getNameFor(this.name, request));
    }

    private Meter meter(Exception e) {
        return this.registry.meter(this.metricNameStrategy.getNameFor(this.name, e));
    }
}

