/*
 * Decompiled with CFR 0.152.
 */
package io.github.springboot.httpclient.actuator;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.httpclient.HttpClientMetricNameStrategy;
import java.net.URISyntaxException;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.RequestLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.utils.URIBuilder;

public class HttpClientMetricNameStrategies {
    public static final HttpClientMetricNameStrategy METHOD_ONLY = (name, request) -> MetricRegistry.name(HttpClient.class, (String[])new String[]{name, HttpClientMetricNameStrategies.methodNameString(request)});
    public static final HttpClientMetricNameStrategy HOST_AND_METHOD = (name, request) -> {
        String host = null;
        Header hostHeader = request.getFirstHeader("Host");
        if (hostHeader != null) {
            host = hostHeader.getValue();
        }
        return MetricRegistry.name(HttpClient.class, (String[])new String[]{name, host, HttpClientMetricNameStrategies.methodNameString(request)});
    };
    public static final HttpClientMetricNameStrategy QUERYLESS_URL_AND_METHOD = (name, request) -> {
        try {
            RequestLine requestLine = request.getRequestLine();
            URIBuilder url = new URIBuilder(requestLine.getUri());
            return MetricRegistry.name(HttpClient.class, (String[])new String[]{name, url.removeQuery().build().toString(), HttpClientMetricNameStrategies.methodNameString(request)});
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    };

    private static String methodNameString(HttpRequest request) {
        return request.getRequestLine().getMethod().toLowerCase() + "-requests";
    }
}

