/*
 * Decompiled with CFR 0.152.
 */
package io.github.springboot.httpclient5.actuator;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.codahale.metrics.httpclient5.HttpClientMetricNameStrategy;
import java.io.IOException;
import lombok.Generated;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActuatorMetricExecChainHandler
implements ExecChainHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ActuatorMetricExecChainHandler.class);
    private final MetricRegistry registry;
    private final HttpClientMetricNameStrategy metricNameStrategy;
    private final String name;

    public ActuatorMetricExecChainHandler(MetricRegistry registry, HttpClientMetricNameStrategy metricNameStrategy) {
        this(registry, metricNameStrategy, null);
    }

    public ActuatorMetricExecChainHandler(MetricRegistry registry, HttpClientMetricNameStrategy metricNameStrategy, String name) {
        this.registry = registry;
        this.name = name;
        this.metricNameStrategy = metricNameStrategy;
    }

    public ClassicHttpResponse execute(ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
        Timer.Context timerContext = this.timer((HttpRequest)request).time();
        try {
            log.debug("before ActuatorMetricExecChainHandler.doExecute");
            ClassicHttpResponse classicHttpResponse = chain.proceed(request, scope);
            return classicHttpResponse;
        }
        catch (IOException | HttpException e) {
            this.meter((Exception)e).mark();
            throw e;
        }
        finally {
            log.debug("after ActuatorMetricExecChainHandler.doExecute");
            timerContext.stop();
        }
    }

    private Timer timer(HttpRequest request) {
        return this.registry.timer(this.metricNameStrategy.getNameFor(this.name, request));
    }

    private Meter meter(Exception e) {
        return this.registry.meter(this.metricNameStrategy.getNameFor(this.name, e));
    }
}

