/*
 * Decompiled with CFR 0.152.
 */
package io.github.springboot.httpclient5.actuator.autoconfigure;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.httpclient5.HttpClientMetricNameStrategies;
import com.codahale.metrics.httpclient5.HttpClientMetricNameStrategy;
import com.codahale.metrics.jmx.JmxReporter;
import io.github.springboot.httpclient5.actuator.ActuatorMetricExecChainHandler;
import io.github.springboot.httpclient5.actuator.HttpAsyncClientEndpoint;
import io.github.springboot.httpclient5.actuator.HttpClientEndpoint;
import io.github.springboot.httpclient5.actuator.InstrumentedAsyncExecChainHandler;
import io.github.springboot.httpclient5.core.config.HttpClient5Config;
import jakarta.annotation.PreDestroy;
import org.apache.hc.client5.http.async.AsyncExecChainHandler;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
@ConditionalOnProperty(name={"spring.httpclient5.core.actuator.enabled"}, havingValue="true", matchIfMissing=true)
public class HttpClientActuatorAutoConfiguration {
    private static final String SYNC_METRICS_PREFIX = HttpClientConnectionManager.class.getName();
    private static final String ASYNC_METRICS_PREFIX = AsyncClientConnectionManager.class.getName();
    @Autowired
    protected HttpClient5Config config;
    private String name;
    private MetricRegistry metricRegistry;

    @Bean(value={"legacyMetricRegistry"})
    public MetricRegistry getMetricsRegistry(PoolingHttpClientConnectionManager cm, PoolingAsyncClientConnectionManager asyncCm) {
        this.metricRegistry = new MetricRegistry();
        this.metricRegistry.registerGauge(MetricRegistry.name((String)SYNC_METRICS_PREFIX, (String[])new String[]{this.name, "available-connections"}), () -> cm.getTotalStats().getAvailable());
        this.metricRegistry.registerGauge(MetricRegistry.name((String)SYNC_METRICS_PREFIX, (String[])new String[]{this.name, "leased-connections"}), () -> cm.getTotalStats().getLeased());
        this.metricRegistry.registerGauge(MetricRegistry.name((String)SYNC_METRICS_PREFIX, (String[])new String[]{this.name, "max-connections"}), () -> cm.getTotalStats().getMax());
        this.metricRegistry.registerGauge(MetricRegistry.name((String)SYNC_METRICS_PREFIX, (String[])new String[]{this.name, "pending-connections"}), () -> cm.getTotalStats().getPending());
        this.metricRegistry.registerGauge(MetricRegistry.name((String)ASYNC_METRICS_PREFIX, (String[])new String[]{this.name, "available-connections"}), () -> asyncCm.getTotalStats().getAvailable());
        this.metricRegistry.registerGauge(MetricRegistry.name((String)ASYNC_METRICS_PREFIX, (String[])new String[]{this.name, "leased-connections"}), () -> asyncCm.getTotalStats().getLeased());
        this.metricRegistry.registerGauge(MetricRegistry.name((String)ASYNC_METRICS_PREFIX, (String[])new String[]{this.name, "max-connections"}), () -> asyncCm.getTotalStats().getMax());
        this.metricRegistry.registerGauge(MetricRegistry.name((String)ASYNC_METRICS_PREFIX, (String[])new String[]{this.name, "pending-connections"}), () -> asyncCm.getTotalStats().getPending());
        return this.metricRegistry;
    }

    @PreDestroy
    public void dispose() {
        this.metricRegistry.remove(MetricRegistry.name((String)SYNC_METRICS_PREFIX, (String[])new String[]{this.name, "available-connections"}));
        this.metricRegistry.remove(MetricRegistry.name((String)SYNC_METRICS_PREFIX, (String[])new String[]{this.name, "leased-connections"}));
        this.metricRegistry.remove(MetricRegistry.name((String)SYNC_METRICS_PREFIX, (String[])new String[]{this.name, "max-connections"}));
        this.metricRegistry.remove(MetricRegistry.name((String)SYNC_METRICS_PREFIX, (String[])new String[]{this.name, "pending-connections"}));
        this.metricRegistry.remove(MetricRegistry.name((String)ASYNC_METRICS_PREFIX, (String[])new String[]{this.name, "available-connections"}));
        this.metricRegistry.remove(MetricRegistry.name((String)ASYNC_METRICS_PREFIX, (String[])new String[]{this.name, "leased-connections"}));
        this.metricRegistry.remove(MetricRegistry.name((String)ASYNC_METRICS_PREFIX, (String[])new String[]{this.name, "max-connections"}));
        this.metricRegistry.remove(MetricRegistry.name((String)ASYNC_METRICS_PREFIX, (String[])new String[]{this.name, "pending-connections"}));
    }

    @Bean
    public HttpClientEndpoint httpClientEndpoint(@Qualifier(value="legacyMetricRegistry") MetricRegistry metricRegistry) {
        return new HttpClientEndpoint(this.config, metricRegistry);
    }

    @Bean
    public HttpAsyncClientEndpoint asyncHttpClientEndpoint(@Qualifier(value="legacyMetricRegistry") MetricRegistry metricRegistry) {
        return new HttpAsyncClientEndpoint(this.config, metricRegistry);
    }

    @Bean
    public JmxReporter jmxExporter(@Qualifier(value="legacyMetricRegistry") MetricRegistry metricRegistry) {
        JmxReporter reporter = JmxReporter.forRegistry((MetricRegistry)metricRegistry).inDomain(this.config.getJmx().getDomain()).build();
        reporter.start();
        return reporter;
    }

    @Bean
    @Order(value=0x7FFFFFFF)
    public ExecChainHandler syncInstrumentedExecChainHandler(@Qualifier(value="legacyMetricRegistry") MetricRegistry metricRegistry) {
        HttpClientMetricNameStrategy metricNameStrategy = this.getMetricNameStrategy(this.config.getJmx().getMetricNameStrategy());
        return new ActuatorMetricExecChainHandler(metricRegistry, metricNameStrategy);
    }

    @Bean
    @Order(value=0x7FFFFFFF)
    public AsyncExecChainHandler asyncInstrumentedExecChainHandler(@Qualifier(value="legacyMetricRegistry") MetricRegistry metricRegistry) {
        HttpClientMetricNameStrategy metricNameStrategy = this.getMetricNameStrategy(this.config.getJmx().getMetricNameStrategy());
        return new InstrumentedAsyncExecChainHandler(metricRegistry, metricNameStrategy);
    }

    private HttpClientMetricNameStrategy getMetricNameStrategy(String name) {
        HttpClientMetricNameStrategy nameStrategy = HttpClientMetricNameStrategies.HOST_AND_METHOD;
        if ("QUERYLESS_URL_AND_METHOD".equalsIgnoreCase(name)) {
            nameStrategy = HttpClientMetricNameStrategies.QUERYLESS_URL_AND_METHOD;
        } else if ("METHOD_ONLY".equalsIgnoreCase(name)) {
            nameStrategy = HttpClientMetricNameStrategies.METHOD_ONLY;
        }
        return nameStrategy;
    }
}

