/*
 * Decompiled with CFR 0.152.
 */
package io.github.springboot.httpclient5.actuator;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import io.github.springboot.httpclient5.core.config.HttpClient5Config;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;

@Endpoint(id="httpclient5")
public class HttpClientEndpoint {
    private final HttpClient5Config properties;
    private final MetricRegistry registry;

    public HttpClientEndpoint(HttpClient5Config configuration, MetricRegistry registry) {
        this.properties = configuration;
        this.registry = registry;
    }

    @ReadOperation
    public Map<String, Object> getData() {
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("author", "stephane.routhiau@gmail.com");
        info.put("httpcomponents", "http://hc.apache.org");
        info.put("metrics", this.getMetrics());
        info.put("config", this.properties);
        return info;
    }

    public Map<String, Object> getMetrics() {
        HashMap<String, Object> metrics = new HashMap<String, Object>();
        SortedMap gauges = this.registry.getGauges((name, metric) -> name.startsWith("org.apache.hc.client5.http.io.HttpClientConnectionManager."));
        for (Map.Entry entry : gauges.entrySet()) {
            metrics.put((String)entry.getKey(), ((Gauge)entry.getValue()).getValue());
        }
        SortedMap timers = this.registry.getTimers((name, metric) -> name.startsWith("org.apache.hc.client5.http.classic.HttpClient."));
        for (Map.Entry entry : timers.entrySet()) {
            metrics.putAll(this.convertTimerToMap((String)entry.getKey(), (Timer)entry.getValue()));
        }
        return metrics;
    }

    public Map<String, Object> convertTimerToMap(String name, Timer timer) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(name + ".count", timer.getCount());
        map.put(name + ".oneMinuteRate", timer.getOneMinuteRate());
        map.put(name + ".fiveMinuteRate", timer.getFiveMinuteRate());
        map.put(name + ".fifteenMinuteRate", timer.getFifteenMinuteRate());
        map.put(name + ".meanRate", timer.getMeanRate());
        Snapshot snapshot = timer.getSnapshot();
        map.put(name + ".snapshot.mean", snapshot.getMean());
        map.put(name + ".snapshot.max", snapshot.getMax());
        map.put(name + ".snapshot.min", snapshot.getMin());
        map.put(name + ".snapshot.median", snapshot.getMedian());
        map.put(name + ".snapshot.stdDev", snapshot.getStdDev());
        map.put(name + ".snapshot.75thPercentile", snapshot.get75thPercentile());
        map.put(name + ".snapshot.95thPercentile", snapshot.get95thPercentile());
        map.put(name + ".snapshot.98thPercentile", snapshot.get98thPercentile());
        map.put(name + ".snapshot.99thPercentile", snapshot.get99thPercentile());
        map.put(name + ".snapshot.999thPercentile", snapshot.get999thPercentile());
        return map;
    }
}

