/*
 * Decompiled with CFR 0.152.
 */
package io.github.springboot.httpclient5.resilience4j;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import io.github.springboot.httpclient5.core.config.HttpClient5Config;
import io.github.springboot.httpclient5.core.config.model.RequestConfigProperties;
import io.github.springboot.httpclient5.resilience4j.Resilience4JAsyncExecCallback;
import java.io.IOException;
import java.net.URISyntaxException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.async.AsyncExecCallback;
import org.apache.hc.client5.http.async.AsyncExecChain;
import org.apache.hc.client5.http.async.AsyncExecChainHandler;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.nio.AsyncDataConsumer;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResilienceAsyncExecChainHandler
implements AsyncExecChainHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResilienceAsyncExecChainHandler.class);
    private final CircuitBreakerRegistry cbRegistry;
    private final RateLimiterRegistry rlregstry;
    private final HttpClient5Config config;

    public ResilienceAsyncExecChainHandler(HttpClient5Config config, CircuitBreakerRegistry cbRegistry, RateLimiterRegistry rlregstry) {
        this.config = config;
        this.cbRegistry = cbRegistry;
        this.rlregstry = rlregstry;
    }

    public void execute(HttpRequest request, AsyncEntityProducer entityProducer, AsyncExecChain.Scope scope, AsyncExecChain chain, AsyncExecCallback asyncExecCallback) throws HttpException, IOException {
        String requestUri;
        String method = request.getMethod();
        try {
            requestUri = request.getUri().toString();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        RequestConfigProperties requestConfigProperties = this.config.getRequestConfigProperties(method, requestUri);
        String circuitName = requestConfigProperties.getErrorManagement().getCircuitName();
        CircuitBreaker circuitBreaker = this.cbRegistry.circuitBreaker(circuitName);
        if (log.isTraceEnabled()) {
            log.trace("Before circuit breakers {} state {}, metrics {}", new Object[]{circuitBreaker.getName(), circuitBreaker.getState(), ToStringBuilder.reflectionToString((Object)circuitBreaker.getMetrics())});
        }
        if (circuitBreaker.tryAcquirePermission()) {
            if (circuitName != "default") {
                RateLimiter rateLimiter = this.rlregstry.rateLimiter(circuitName);
                RateLimiter.waitForPermission((RateLimiter)rateLimiter);
            }
            Resilience4JAsyncExecCallback instrumentedAsyncExecCallback = new Resilience4JAsyncExecCallback(circuitBreaker, asyncExecCallback, request);
            chain.proceed(request, entityProducer, scope, (AsyncExecCallback)instrumentedAsyncExecCallback);
        } else {
            String action = requestConfigProperties.getErrorManagement().getBrokenCircuitAction();
            if (StringUtils.isNumeric((CharSequence)action)) {
                SimpleHttpResponse definedErrorResponse = new SimpleHttpResponse(Integer.parseInt(action), "Broken circuit : " + circuitBreaker.toString());
                asyncExecCallback.handleInformationResponse((HttpResponse)definedErrorResponse);
                asyncExecCallback.handleResponse((HttpResponse)definedErrorResponse, null);
                asyncExecCallback.completed();
            } else {
                throw new ClientProtocolException("Broken circuit : " + circuitBreaker.toString() + " is closed");
            }
        }
    }

    private final class DefinedResponseAsyncExecCallback
    implements AsyncExecCallback {
        private final SimpleHttpResponse definedErrorResponse;
        private final AsyncExecCallback asyncExecCallback;

        private DefinedResponseAsyncExecCallback(SimpleHttpResponse definedErrorResponse, AsyncExecCallback asyncExecCallback) {
            this.definedErrorResponse = definedErrorResponse;
            this.asyncExecCallback = asyncExecCallback;
        }

        public AsyncDataConsumer handleResponse(HttpResponse response, EntityDetails entityDetails) throws HttpException, IOException {
            return this.asyncExecCallback.handleResponse((HttpResponse)this.definedErrorResponse, entityDetails);
        }

        public void handleInformationResponse(HttpResponse response) throws HttpException, IOException {
            this.asyncExecCallback.handleInformationResponse((HttpResponse)this.definedErrorResponse);
        }

        public void failed(Exception cause) {
            this.asyncExecCallback.failed(cause);
        }

        public void completed() {
            this.asyncExecCallback.completed();
        }
    }
}

