/*
 * Decompiled with CFR 0.152.
 */
package io.github.springboot.httpclient5.resilience4j;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.hc.client5.http.async.AsyncExecCallback;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.nio.AsyncDataConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resilience4JAsyncExecCallback
implements AsyncExecCallback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Resilience4JAsyncExecCallback.class);
    private final AsyncExecCallback delegate;
    private CircuitBreaker circuitBreaker;
    long start = System.nanoTime();

    public Resilience4JAsyncExecCallback(CircuitBreaker circuitBreaker, AsyncExecCallback delegate, HttpRequest request) {
        this.circuitBreaker = circuitBreaker;
        this.delegate = delegate;
    }

    public AsyncDataConsumer handleResponse(HttpResponse response, EntityDetails entityDetails) throws HttpException, IOException {
        this.internalHandleResponse(response);
        return this.delegate.handleResponse(response, entityDetails);
    }

    public void handleInformationResponse(HttpResponse response) throws HttpException, IOException {
        this.internalHandleResponse(response);
        this.delegate.handleInformationResponse(response);
    }

    private void internalHandleResponse(HttpResponse response) {
        int statusCode = response.getCode();
        long durationInNanos = System.nanoTime() - this.start;
        if (this.isError(statusCode)) {
            this.circuitBreaker.onError(durationInNanos, TimeUnit.NANOSECONDS, (Throwable)new IOException("Http Status Error " + statusCode));
            log.debug("After http 5xx circuit breakers state {}, metrics {}", (Object)this.circuitBreaker.getState(), (Object)ToStringBuilder.reflectionToString((Object)this.circuitBreaker.getMetrics()));
        } else {
            this.circuitBreaker.onSuccess(durationInNanos, TimeUnit.NANOSECONDS);
        }
    }

    public void completed() {
        this.delegate.completed();
    }

    public void failed(Exception cause) {
        long durationInNanos = System.nanoTime() - this.start;
        this.circuitBreaker.onError(durationInNanos, TimeUnit.NANOSECONDS, (Throwable)cause);
        log.debug("After exception circuit breakers state {}, metrics {}", (Object)this.circuitBreaker.getState(), (Object)ToStringBuilder.reflectionToString((Object)this.circuitBreaker.getMetrics()));
        this.delegate.failed(cause);
    }

    private boolean isError(int code) {
        return code >= 500;
    }
}

