/*
 * Decompiled with CFR 0.152.
 */
package io.github.springboot.httpclient5.resilience4j;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.springboot.httpclient5.core.config.HttpClient5Config;
import io.github.springboot.httpclient5.core.config.model.RequestConfigProperties;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResilienceExecChainHandler
implements ExecChainHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResilienceExecChainHandler.class);
    private final CircuitBreakerRegistry cbRegistry;
    private final RateLimiterRegistry rlregstry;
    private final HttpClient5Config config;

    public ResilienceExecChainHandler(HttpClient5Config config, CircuitBreakerRegistry cbRegistry, RateLimiterRegistry rlregstry) {
        this.config = config;
        this.cbRegistry = cbRegistry;
        this.rlregstry = rlregstry;
    }

    public ClassicHttpResponse execute(ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
        String method = request.getMethod();
        String requestUri = request.getUri().toString();
        RequestConfigProperties requestConfigProperties = this.config.getRequestConfigProperties(method, requestUri);
        String circuitName = requestConfigProperties.getErrorManagement().getCircuitName();
        CircuitBreaker circuitBreaker = this.cbRegistry.circuitBreaker(circuitName);
        if (log.isTraceEnabled()) {
            log.trace("Before circuit breakers {} state {}, metrics {}", new Object[]{circuitBreaker.getName(), circuitBreaker.getState(), ToStringBuilder.reflectionToString((Object)circuitBreaker.getMetrics())});
        }
        if (circuitBreaker.tryAcquirePermission()) {
            long start = System.nanoTime();
            Retry retry = Retry.of((String)circuitName, (RetryConfig)ResilienceExecChainHandler.getRetryConfig(requestConfigProperties));
            Retry.Context retryContext = retry.context();
            while (true) {
                try {
                    ClassicHttpResponse response;
                    boolean validationOfResult;
                    do {
                        if (circuitName != "default") {
                            RateLimiter rateLimiter = this.rlregstry.rateLimiter(circuitName);
                            RateLimiter.waitForPermission((RateLimiter)rateLimiter);
                        }
                        response = chain.proceed(request, scope);
                        int statusCode = response.getCode();
                        long durationInNanos = System.nanoTime() - start;
                        if (this.isError(statusCode)) {
                            circuitBreaker.onError(durationInNanos, TimeUnit.NANOSECONDS, (Throwable)new IOException("Http Status Error " + statusCode));
                            log.debug("After http 5xx circuit breakers state {}, metrics {}", (Object)circuitBreaker.getState(), (Object)ToStringBuilder.reflectionToString((Object)circuitBreaker.getMetrics()));
                            continue;
                        }
                        circuitBreaker.onSuccess(durationInNanos, TimeUnit.NANOSECONDS);
                    } while (validationOfResult = retryContext.onResult((Object)response));
                    retryContext.onComplete();
                    return response;
                }
                catch (Throwable throwable) {
                    long durationInNanos = System.nanoTime() - start;
                    circuitBreaker.onError(durationInNanos, TimeUnit.NANOSECONDS, throwable);
                    log.debug("After exception circuit breakers state {}, metrics {}", (Object)circuitBreaker.getState(), (Object)ToStringBuilder.reflectionToString((Object)circuitBreaker.getMetrics()));
                    retryContext.onRuntimeError(new RuntimeException(throwable));
                    continue;
                }
                break;
            }
        }
        return this.brokenCircuitResponse(circuitBreaker, requestConfigProperties.getErrorManagement().getBrokenCircuitAction());
    }

    protected static RetryConfig getRetryConfig(RequestConfigProperties requestConfigProperties) {
        Integer maxAttempts = requestConfigProperties.getErrorManagement().getMaxAttempts();
        Integer waitDuration = requestConfigProperties.getErrorManagement().getWaitDuration();
        RetryConfig retryConfig = RetryConfig.custom().maxAttempts(maxAttempts == null ? 1 : maxAttempts).waitDuration(Duration.ofMillis(waitDuration == null ? 10L : (long)waitDuration.intValue())).build();
        return retryConfig;
    }

    private boolean isError(int code) {
        return code >= 500;
    }

    private BasicClassicHttpResponse brokenCircuitResponse(CircuitBreaker circuitBreaker, String action) throws ClientProtocolException {
        if (StringUtils.isNumeric((CharSequence)action)) {
            return new BasicClassicHttpResponse(Integer.parseInt(action), "Broken circuit : " + circuitBreaker.toString());
        }
        throw new ClientProtocolException("Broken circuit : " + circuitBreaker.toString() + " is closed");
    }
}

