/*
 * Decompiled with CFR 0.152.
 */
package io.github.springboot.httpclient5.core.configure;

import java.util.Date;
import java.util.List;
import org.apache.hc.client5.http.cookie.BasicCookieStore;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DefaultCookieStoresProvider {
    @Bean
    @ConditionalOnProperty(name={"spring.httpclient5.core.cookie-store.type"}, havingValue="thread-local", matchIfMissing=false)
    public CookieStore threadLocalCookieStore() {
        return new ThreadLocalCookieStore();
    }

    @Bean
    @ConditionalOnProperty(name={"spring.httpclient5.core.cookie-store.type"}, havingValue="shared", matchIfMissing=true)
    public CookieStore sharedCookieStore() {
        return new BasicCookieStore();
    }

    public static class ThreadLocalCookieStore
    implements CookieStore {
        private final ThreadLocal<BasicCookieStore> cookieStores = ThreadLocal.withInitial(() -> new BasicCookieStore());

        public void addCookie(Cookie cookie) {
            this.cookieStores.get().addCookie(cookie);
        }

        public List<Cookie> getCookies() {
            return this.cookieStores.get().getCookies();
        }

        public boolean clearExpired(Date date) {
            return this.cookieStores.get().clearExpired(date);
        }

        public void clear() {
            this.cookieStores.get().clear();
        }
    }
}

