/*
 * Decompiled with CFR 0.152.
 */
package io.github.springboot.httpclient5.core.configure;

import io.github.springboot.httpclient5.core.config.HttpClient5Config;
import io.github.springboot.httpclient5.core.configure.ConfigurableHttpRequestRetryStrategy;
import org.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.auth.CredentialsStore;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.fluent.Executor;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class HttpClientConfigurer {
    @Autowired(required=false)
    private ObjectProvider<HttpClientBuilder> httpClientBuilderProvider;
    @Autowired(required=false)
    private ObjectProvider<CookieStore> cookieStoreProvider;
    @Autowired
    private ObjectProvider<HttpRequestInterceptor> requestInterceptors;
    @Autowired
    private ObjectProvider<ExecChainHandler> execChainHandlerProvider;
    @Autowired
    private ObjectProvider<HttpResponseInterceptor> responseInterceptors;
    @Autowired
    private ObjectProvider<CredentialsStore> credentialsStoreProvider;
    @Autowired
    private ObjectProvider<HttpRequestRetryStrategy> httpRequestRetryStrategyProvider;
    @Autowired
    private ObjectProvider<ConnectionReuseStrategy> connectionReuseStrategyProvider;
    @Autowired
    private ObjectProvider<ConnectionKeepAliveStrategy> connectionKeepAliveStrategyProvider;
    @Autowired
    private HttpClient5Config config;

    @Bean
    public Executor httpClientExecutor(CloseableHttpClient httpClient) {
        return Executor.newInstance((CloseableHttpClient)httpClient);
    }

    @Bean
    public CloseableHttpClient closeableHttpClient(PoolingHttpClientConnectionManager cm) {
        HttpClientBuilder builder = (HttpClientBuilder)this.httpClientBuilderProvider.getIfAvailable(HttpClientBuilder::create);
        builder.setUserAgent(this.config.getUserAgent());
        builder.setConnectionManager((HttpClientConnectionManager)cm);
        this.requestInterceptors.orderedStream().forEach(arg_0 -> ((HttpClientBuilder)builder).addRequestInterceptorLast(arg_0));
        this.responseInterceptors.orderedStream().forEach(arg_0 -> ((HttpClientBuilder)builder).addResponseInterceptorLast(arg_0));
        this.execChainHandlerProvider.orderedStream().forEach(e -> builder.addExecInterceptorFirst(e.getClass().getName(), e));
        if (this.cookieStoreProvider.getIfAvailable() == null) {
            builder.disableCookieManagement();
        }
        this.cookieStoreProvider.ifAvailable(arg_0 -> ((HttpClientBuilder)builder).setDefaultCookieStore(arg_0));
        this.credentialsStoreProvider.ifAvailable(arg_0 -> ((HttpClientBuilder)builder).setDefaultCredentialsProvider(arg_0));
        this.connectionKeepAliveStrategyProvider.ifAvailable(arg_0 -> ((HttpClientBuilder)builder).setKeepAliveStrategy(arg_0));
        this.connectionReuseStrategyProvider.ifAvailable(arg_0 -> ((HttpClientBuilder)builder).setConnectionReuseStrategy(arg_0));
        HttpRequestRetryStrategy retryStrategy = (HttpRequestRetryStrategy)this.httpRequestRetryStrategyProvider.getIfAvailable();
        if (retryStrategy == null) {
            retryStrategy = new ConfigurableHttpRequestRetryStrategy(this.config);
        }
        builder.setRetryStrategy(retryStrategy);
        return builder.build();
    }
}

