/*
 * Decompiled with CFR 0.152.
 */
package io.github.springboot.httpclient5.core.configure.async;

import io.github.springboot.httpclient5.core.config.HttpClient5Config;
import io.github.springboot.httpclient5.core.configure.ConfigurableHttpRequestRetryStrategy;
import io.github.springboot.httpclient5.core.utils.ThreadFactoryUtils;
import org.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.async.AsyncExecChainHandler;
import org.apache.hc.client5.http.auth.CredentialsStore;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class HttpAsyncClientConfigurer {
    @Autowired(required=false)
    private ObjectProvider<HttpAsyncClientBuilder> httpAsyncClientBuilderProvider;
    @Autowired(required=false)
    private ObjectProvider<CookieStore> cookieStoreProvider;
    @Autowired
    private ObjectProvider<HttpRequestInterceptor> requestInterceptors;
    @Autowired
    private ObjectProvider<AsyncExecChainHandler> execChainHandlerProvider;
    @Autowired
    private ObjectProvider<HttpResponseInterceptor> responseInterceptors;
    @Autowired
    private ObjectProvider<CredentialsStore> credentialsStoreProvider;
    @Autowired
    private ObjectProvider<HttpRequestRetryStrategy> httpRequestRetryStrategyProvider;
    @Autowired
    private ObjectProvider<ConnectionReuseStrategy> connectionReuseStrategyProvider;
    @Autowired
    private ObjectProvider<ConnectionKeepAliveStrategy> connectionKeepAliveStrategyProvider;
    @Autowired
    private HttpClient5Config config;

    @Bean(destroyMethod="initiateShutdown")
    public CloseableHttpAsyncClient closeableHttpAsyncClient(PoolingAsyncClientConnectionManager cm) {
        HttpAsyncClientBuilder builder = (HttpAsyncClientBuilder)this.httpAsyncClientBuilderProvider.getIfAvailable(HttpAsyncClientBuilder::create);
        builder.setUserAgent(this.config.getUserAgent());
        builder.setConnectionManager((AsyncClientConnectionManager)cm);
        this.requestInterceptors.orderedStream().forEach(arg_0 -> ((HttpAsyncClientBuilder)builder).addRequestInterceptorLast(arg_0));
        this.responseInterceptors.orderedStream().forEach(arg_0 -> ((HttpAsyncClientBuilder)builder).addResponseInterceptorLast(arg_0));
        this.execChainHandlerProvider.orderedStream().forEach(e -> builder.addExecInterceptorFirst(e.getClass().getName(), e));
        if (this.cookieStoreProvider.getIfAvailable() == null) {
            builder.disableCookieManagement();
        }
        this.cookieStoreProvider.ifAvailable(arg_0 -> ((HttpAsyncClientBuilder)builder).setDefaultCookieStore(arg_0));
        this.credentialsStoreProvider.ifAvailable(arg_0 -> ((HttpAsyncClientBuilder)builder).setDefaultCredentialsProvider(arg_0));
        this.connectionKeepAliveStrategyProvider.ifAvailable(arg_0 -> ((HttpAsyncClientBuilder)builder).setKeepAliveStrategy(arg_0));
        this.connectionReuseStrategyProvider.ifAvailable(arg_0 -> ((HttpAsyncClientBuilder)builder).setConnectionReuseStrategy(arg_0));
        HttpRequestRetryStrategy retryStrategy = (HttpRequestRetryStrategy)this.httpRequestRetryStrategyProvider.getIfAvailable();
        if (retryStrategy == null) {
            retryStrategy = new ConfigurableHttpRequestRetryStrategy(this.config);
        }
        builder.setRetryStrategy(retryStrategy);
        builder.setIOReactorConfig(this.config.getIoReactor().build());
        builder.setThreadFactory(ThreadFactoryUtils.getThreadFactory());
        CloseableHttpAsyncClient asyncClient = builder.build();
        asyncClient.start();
        return asyncClient;
    }
}

