/*
 * Decompiled with CFR 0.152.
 */
package io.github.springboot.httpclient5.core.interceptors;

import io.github.springboot.httpclient5.core.config.HttpClient5Config;
import io.github.springboot.httpclient5.core.config.model.RequestConfigProperties;
import io.github.springboot.httpclient5.core.config.model.SimplePredefinedCredentialsProvider;
import java.io.IOException;
import java.net.URI;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=-2147483648)
@Component
public class HttpRequestConfigurerInterceptor
implements HttpRequestInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpRequestConfigurerInterceptor.class);
    static final String REQUEST_CONFIG_EXTENDED = "http.request-config-extended";
    private final HttpClient5Config config;

    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        try {
            URI uri = request.getUri();
            String method = request.getMethod();
            log.debug("Configuring httpclient for {} {}", (Object)method, (Object)uri);
            RequestConfigProperties requestConfigProperties = this.config.getRequestConfigProperties(method, uri.toString());
            RequestConfig requestConfig = requestConfigProperties.build();
            HttpClientContext.castOrCreate((HttpContext)context).setRequestConfig(requestConfig);
            context.setAttribute(REQUEST_CONFIG_EXTENDED, (Object)requestConfigProperties);
            SimplePredefinedCredentialsProvider credentials = requestConfigProperties.getCredentials();
            if (credentials != null && credentials.isPreemptive()) {
                Header header = request.getHeader("Authorization");
                if (header == null || StringUtils.isBlank((CharSequence)header.getValue())) {
                    request.addHeader((Header)new BasicHeader("Authorization", (Object)("Basic " + credentials.toBase64Encoded())));
                } else {
                    log.debug("Autorization header present, skipping configured auth {}", (Object)credentials);
                }
            } else {
                context.setAttribute("http.auth.credentials-provider", (Object)requestConfigProperties.getCredentials());
                HttpClientContext.castOrCreate((HttpContext)context).setCredentialsProvider((CredentialsProvider)requestConfigProperties.getCredentials());
            }
            requestConfigProperties.getCustomRequestContext().forEach((arg_0, arg_1) -> ((HttpContext)context).setAttribute(arg_0, arg_1));
        }
        catch (Exception e) {
            log.warn("Unable to configure httpclient request, no uri available : using defaut configuration", (Throwable)e);
        }
    }

    @Generated
    public HttpRequestConfigurerInterceptor(HttpClient5Config config) {
        this.config = config;
    }
}

