/*
 * Decompiled with CFR 0.152.
 */
package io.github.springboot.httpclient5.core.configure;

import io.github.springboot.httpclient5.core.config.HttpClient5Config;
import io.github.springboot.httpclient5.core.config.model.RetryConfig;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLException;
import lombok.Generated;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.concurrent.CancellableDependency;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.RequestNotExecutedException;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurableHttpRequestRetryStrategy
implements HttpRequestRetryStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigurableHttpRequestRetryStrategy.class);
    private static final String RETRY_INTERVAL = "RETRY_INTERVAL";
    private static final String MAX_RETRIES = "MAX_RETRIES";
    private final Set<Class<? extends IOException>> nonRetriableIOExceptionClasses;
    private final Set<Integer> retriableCodes;
    private HttpClient5Config config;

    public ConfigurableHttpRequestRetryStrategy(HttpClient5Config config, Collection<Class<? extends IOException>> clazzes, Collection<Integer> codes) {
        this.nonRetriableIOExceptionClasses = new HashSet<Class<? extends IOException>>(clazzes);
        this.retriableCodes = new HashSet<Integer>(codes);
        this.config = config;
    }

    public ConfigurableHttpRequestRetryStrategy(HttpClient5Config config) {
        this(config, Arrays.asList(InterruptedIOException.class, UnknownHostException.class, ConnectException.class, ConnectionClosedException.class, NoRouteToHostException.class, SSLException.class), Arrays.asList(429, 503));
    }

    public boolean retryRequest(HttpRequest request, IOException exception, int execCount, HttpContext context) {
        Args.notNull((Object)request, (String)"request");
        Args.notNull((Object)exception, (String)"exception");
        if (execCount > this.getMaxRetries(request, context)) {
            return false;
        }
        if (this.nonRetriableIOExceptionClasses.contains(exception.getClass())) {
            return false;
        }
        if (exception instanceof RequestNotExecutedException) {
            log.debug("retry {} of {}", (Object)execCount, (Object)request.getRequestUri());
            return true;
        }
        for (Class<? extends IOException> rejectException : this.nonRetriableIOExceptionClasses) {
            if (!rejectException.isInstance(exception)) continue;
            return false;
        }
        if (request instanceof CancellableDependency && ((CancellableDependency)request).isCancelled()) {
            return false;
        }
        boolean handleAsIdempotent = this.handleAsIdempotent(request);
        if (handleAsIdempotent) {
            log.debug("retry {} of {}", (Object)execCount, (Object)request.getRequestUri());
        }
        return handleAsIdempotent;
    }

    public boolean retryRequest(HttpResponse response, int execCount, HttpContext context) {
        boolean retryable;
        Args.notNull((Object)response, (String)"response");
        Object val = context.getAttribute(MAX_RETRIES);
        HttpRequest request = HttpClientContext.castOrCreate((HttpContext)context).getRequest();
        Integer maxRetries = val != null ? (Integer)val : Integer.valueOf(this.getMaxRetries(request, context));
        boolean bl = retryable = execCount <= maxRetries && this.retriableCodes.contains(response.getCode());
        if (retryable) {
            try {
                log.debug("retry {} of {} {}", new Object[]{execCount, request.getMethod(), request.getUri()});
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return retryable;
    }

    public TimeValue getRetryInterval(HttpResponse response, int execCount, HttpContext context) {
        Args.notNull((Object)response, (String)"response");
        Header header = response.getFirstHeader("Retry-After");
        TimeValue retryAfter = null;
        if (header != null) {
            block4: {
                String value = header.getValue();
                try {
                    retryAfter = TimeValue.ofSeconds((long)Long.parseLong(value));
                }
                catch (NumberFormatException ignore) {
                    Date retryAfterDate = DateUtils.parseDate((String)value);
                    if (retryAfterDate == null) break block4;
                    retryAfter = TimeValue.ofMilliseconds((long)(retryAfterDate.getTime() - System.currentTimeMillis()));
                }
            }
            if (TimeValue.isPositive((TimeValue)retryAfter)) {
                return retryAfter;
            }
        }
        TimeValue retryInterval = (TimeValue)context.getAttribute(RETRY_INTERVAL);
        return retryInterval;
    }

    protected boolean handleAsIdempotent(HttpRequest request) {
        return Method.isIdempotent((String)request.getMethod());
    }

    public int getMaxRetries(HttpRequest request, HttpContext context) {
        URI uri = request.getUri();
        String method = request.getMethod();
        RetryConfig conf = this.config.getRequestConfigProperties(method, uri.toString()).getRetryConfig();
        Integer maxRetries = conf.getMaxRetries() == null ? 0 : conf.getMaxRetries();
        context.setAttribute(MAX_RETRIES, (Object)maxRetries);
        context.setAttribute(RETRY_INTERVAL, (Object)conf.getRetryInterval());
        return maxRetries;
    }
}

