/*
 * Decompiled with CFR 0.152.
 */
package io.github.springboot.httpclient5.core.configure;

import io.github.springboot.httpclient5.core.config.HttpClient5Config;
import io.github.springboot.httpclient5.core.config.model.CommonsPoolProperties;
import io.github.springboot.httpclient5.core.config.model.ConnectionConfigProperties;
import io.github.springboot.httpclient5.core.config.model.DefaultConfigConfigurer;
import io.github.springboot.httpclient5.core.configure.ConfigurableConnPoolControl;
import io.github.springboot.httpclient5.core.configure.PoolingHttpClientConnectionManagerPostConfigurer;
import java.net.URI;
import java.util.Map;
import lombok.Generated;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.core5.function.Resolver;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MaxPerRouteConnectionManagerConfigurer
implements PoolingHttpClientConnectionManagerPostConfigurer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MaxPerRouteConnectionManagerConfigurer.class);
    private final HttpClient5Config config;
    private final SchemePortResolver schemePortResolver;

    @Override
    public void configure(ConfigurableConnPoolControl cm, boolean asyncPool) {
        DefaultConfigConfigurer poolProperties = asyncPool ? this.config.getAsyncPool() : this.config.getPool();
        poolProperties.getHostConfig().entrySet().stream().forEach(arg_0 -> this.lambda$configure$1(cm, (CommonsPoolProperties)((Object)poolProperties), arg_0));
    }

    protected ConnectionConfig getConnectionConfig(HttpRoute route, CommonsPoolProperties poolProperties) {
        String routeUri = route.getTargetHost().toURI();
        ConnectionConfigProperties connectionConfigProperties = poolProperties.getHostConfig().get(routeUri);
        if (connectionConfigProperties == null) {
            return null;
        }
        if (connectionConfigProperties.getConnectTimeout().equals((Object)Timeout.ofMinutes((long)3L))) {
            connectionConfigProperties.setConnectTimeout(poolProperties.getDefaultConnectionConfig().getConnectTimeout());
        }
        if (log.isDebugEnabled()) {
            log.debug("Using connectionConfig for {} => {}", (Object)routeUri, (Object)connectionConfigProperties);
        }
        return connectionConfigProperties.build();
    }

    protected HttpRoute getHttpRoute(String uri, HttpHost proxy) {
        HttpHost h = HttpHost.create((URI)new URI(uri));
        boolean secure = "https".equals(h.getSchemeName());
        HttpHost target = new HttpHost(h.getSchemeName(), h.getHostName(), this.schemePortResolver.resolve(h));
        return proxy == null ? new HttpRoute(target, null, secure) : new HttpRoute(target, null, proxy, secure);
    }

    @Generated
    public MaxPerRouteConnectionManagerConfigurer(HttpClient5Config config, SchemePortResolver schemePortResolver) {
        this.config = config;
        this.schemePortResolver = schemePortResolver;
    }

    private /* synthetic */ void lambda$configure$1(ConfigurableConnPoolControl cm, CommonsPoolProperties poolProperties, Map.Entry e) {
        Object url = (String)e.getKey();
        if (!((String)url).endsWith("/")) {
            url = (String)url + "/";
        }
        HttpHost proxy = this.config.getRequestConfig("GET", (String)url).getProxy();
        HttpRoute httpRoute = this.getHttpRoute((String)url, proxy);
        ConnectionConfigProperties connProperties = (ConnectionConfigProperties)e.getValue();
        Integer maxConnections = connProperties.getMaxConnections();
        if (maxConnections != null) {
            log.info("Configuring maxPerRoute for {} via {} to {}", new Object[]{url, proxy, maxConnections});
            cm.setMaxPerRoute(httpRoute, maxConnections);
        }
        cm.setConnectionConfigResolver((Resolver<HttpRoute, ConnectionConfig>)((Resolver)route -> this.getConnectionConfig((HttpRoute)route, poolProperties)));
    }
}

