/*
 * Decompiled with CFR 0.152.
 */
package io.github.springboot.httpclient5.core.interceptors;

import io.github.springboot.httpclient5.core.config.model.RequestConfigProperties;
import java.io.IOException;
import lombok.Generated;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.protocol.HttpContext;

public abstract class ActivableHttpInterceptor
implements HttpRequestInterceptor,
HttpResponseInterceptor {
    private final String id;
    private final boolean activateByDefault;

    public ActivableHttpInterceptor(String id) {
        this(id, false);
    }

    public final void process(HttpResponse response, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        if (this.isActivated(context)) {
            this.doProcess(response, entity, context);
        }
    }

    public abstract void doProcess(HttpResponse var1, EntityDetails var2, HttpContext var3) throws HttpException, IOException;

    public final void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        if (this.isActivated(context)) {
            this.doProcess(request, entity, context);
        }
    }

    public abstract void doProcess(HttpRequest var1, EntityDetails var2, HttpContext var3) throws HttpException, IOException;

    protected boolean isActivated(HttpContext context) {
        RequestConfigProperties c = (RequestConfigProperties)context.getAttribute("http.request-config-extended");
        Boolean b = c.getInterceptors().get(this.id);
        return b != null && b != false || b == null && this.activateByDefault;
    }

    @Generated
    public ActivableHttpInterceptor(String id, boolean activateByDefault) {
        this.id = id;
        this.activateByDefault = activateByDefault;
    }
}

