/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.asyncapi.v3.model.channel.message;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.github.springwolf.asyncapi.v3.model.Reference;
import io.github.springwolf.asyncapi.v3.model.channel.message.Message;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageObject;

public class MessageReference
implements Message,
Reference {
    @JsonIgnore
    private String ref;

    @Override
    public String getRef() {
        return this.ref;
    }

    public static MessageReference toComponentMessage(MessageObject message) {
        return MessageReference.toComponentMessage(message.getMessageId());
    }

    public static MessageReference toComponentMessage(String messageId) {
        return new MessageReference("#/components/messages/" + messageId);
    }

    public static MessageReference toChannelMessage(String channelId, MessageObject message) {
        return new MessageReference("#/channels/" + channelId + "/messages/" + message.getMessageId());
    }

    public static MessageReference toChannelMessage(String channelId, String messageId) {
        return new MessageReference("#/channels/" + channelId + "/messages/" + messageId);
    }

    public static MessageReference toSchema(String schemaName) {
        return new MessageReference("#/components/schemas/" + schemaName);
    }

    public static String extractRefName(String ref) {
        if (ref.contains("/")) {
            return ref.substring(ref.lastIndexOf(47) + 1);
        }
        return ref;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageReference)) {
            return false;
        }
        MessageReference other = (MessageReference)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$ref = this.getRef();
        String other$ref = other.getRef();
        return !(this$ref == null ? other$ref != null : !this$ref.equals(other$ref));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MessageReference;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $ref = this.getRef();
        result = result * 59 + ($ref == null ? 43 : $ref.hashCode());
        return result;
    }

    public String toString() {
        return "MessageReference(ref=" + this.getRef() + ")";
    }

    public MessageReference() {
    }

    public MessageReference(String ref) {
        this.ref = ref;
    }
}

