/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.asyncapi.v3.model.security_scheme;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.springwolf.asyncapi.v3.model.security_scheme.SecurityScheme;
import io.github.springwolf.asyncapi.v3.model.security_scheme.SecurityType;
import jakarta.validation.constraints.NotNull;

public class HttpSecurityScheme
extends SecurityScheme {
    @NotNull
    @JsonProperty(value="scheme")
    private String scheme;
    @JsonProperty(value="bearerFormat")
    private String bearerFormat;

    public HttpSecurityScheme(String scheme, String bearerFormat, String description, String ref) {
        super(SecurityType.HTTP, description, ref);
        this.scheme = scheme;
        this.bearerFormat = bearerFormat;
    }

    public static HttpSecuritySchemeBuilder httpBuilder() {
        return new HttpSecuritySchemeBuilder();
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getBearerFormat() {
        return this.bearerFormat;
    }

    @JsonProperty(value="scheme")
    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    @JsonProperty(value="bearerFormat")
    public void setBearerFormat(String bearerFormat) {
        this.bearerFormat = bearerFormat;
    }

    @Override
    public String toString() {
        return "HttpSecurityScheme(scheme=" + this.getScheme() + ", bearerFormat=" + this.getBearerFormat() + ")";
    }

    public HttpSecurityScheme() {
    }

    public HttpSecurityScheme(String scheme, String bearerFormat) {
        this.scheme = scheme;
        this.bearerFormat = bearerFormat;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpSecurityScheme)) {
            return false;
        }
        HttpSecurityScheme other = (HttpSecurityScheme)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$scheme = this.getScheme();
        String other$scheme = other.getScheme();
        if (this$scheme == null ? other$scheme != null : !this$scheme.equals(other$scheme)) {
            return false;
        }
        String this$bearerFormat = this.getBearerFormat();
        String other$bearerFormat = other.getBearerFormat();
        return !(this$bearerFormat == null ? other$bearerFormat != null : !this$bearerFormat.equals(other$bearerFormat));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HttpSecurityScheme;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $scheme = this.getScheme();
        result = result * 59 + ($scheme == null ? 43 : $scheme.hashCode());
        String $bearerFormat = this.getBearerFormat();
        result = result * 59 + ($bearerFormat == null ? 43 : $bearerFormat.hashCode());
        return result;
    }

    public static class HttpSecuritySchemeBuilder {
        private String scheme;
        private String bearerFormat;
        private String description;
        private String ref;

        HttpSecuritySchemeBuilder() {
        }

        public HttpSecuritySchemeBuilder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public HttpSecuritySchemeBuilder bearerFormat(String bearerFormat) {
            this.bearerFormat = bearerFormat;
            return this;
        }

        public HttpSecuritySchemeBuilder description(String description) {
            this.description = description;
            return this;
        }

        public HttpSecuritySchemeBuilder ref(String ref) {
            this.ref = ref;
            return this;
        }

        public HttpSecurityScheme build() {
            return new HttpSecurityScheme(this.scheme, this.bearerFormat, this.description, this.ref);
        }

        public String toString() {
            return "HttpSecurityScheme.HttpSecuritySchemeBuilder(scheme=" + this.scheme + ", bearerFormat=" + this.bearerFormat + ", description=" + this.description + ", ref=" + this.ref + ")";
        }
    }
}

