/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.asyncapi.v3.model.security_scheme;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.springwolf.asyncapi.v3.model.security_scheme.SecurityScheme;
import io.github.springwolf.asyncapi.v3.model.security_scheme.SecurityType;
import io.github.springwolf.asyncapi.v3.model.security_scheme.oauth2.OAuthFlows;
import jakarta.validation.constraints.NotNull;
import java.util.List;

public class OAuth2SecurityScheme
extends SecurityScheme {
    @NotNull
    @JsonProperty(value="flows")
    private OAuthFlows flows;
    @JsonProperty(value="scopes")
    private List<String> scopes;

    public OAuth2SecurityScheme(@NotNull OAuthFlows flows, List<String> scopes, String description, String ref) {
        super(SecurityType.OAUTH2, description, ref);
        this.flows = flows;
        this.scopes = scopes;
    }

    public static OAuth2SecuritySchemeBuilder oAuth2Builder() {
        return new OAuth2SecuritySchemeBuilder();
    }

    public OAuthFlows getFlows() {
        return this.flows;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    @JsonProperty(value="flows")
    public void setFlows(OAuthFlows flows) {
        this.flows = flows;
    }

    @JsonProperty(value="scopes")
    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    @Override
    public String toString() {
        return "OAuth2SecurityScheme(flows=" + this.getFlows() + ", scopes=" + this.getScopes() + ")";
    }

    public OAuth2SecurityScheme() {
    }

    public OAuth2SecurityScheme(OAuthFlows flows, List<String> scopes) {
        this.flows = flows;
        this.scopes = scopes;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuth2SecurityScheme)) {
            return false;
        }
        OAuth2SecurityScheme other = (OAuth2SecurityScheme)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OAuthFlows this$flows = this.getFlows();
        OAuthFlows other$flows = other.getFlows();
        if (this$flows == null ? other$flows != null : !((Object)this$flows).equals(other$flows)) {
            return false;
        }
        List<String> this$scopes = this.getScopes();
        List<String> other$scopes = other.getScopes();
        return !(this$scopes == null ? other$scopes != null : !((Object)this$scopes).equals(other$scopes));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OAuth2SecurityScheme;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        OAuthFlows $flows = this.getFlows();
        result = result * 59 + ($flows == null ? 43 : ((Object)$flows).hashCode());
        List<String> $scopes = this.getScopes();
        result = result * 59 + ($scopes == null ? 43 : ((Object)$scopes).hashCode());
        return result;
    }

    public static class OAuth2SecuritySchemeBuilder {
        private OAuthFlows flows;
        private List<String> scopes;
        private String description;
        private String ref;

        OAuth2SecuritySchemeBuilder() {
        }

        public OAuth2SecuritySchemeBuilder flows(OAuthFlows flows) {
            this.flows = flows;
            return this;
        }

        public OAuth2SecuritySchemeBuilder scopes(List<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        public OAuth2SecuritySchemeBuilder description(String description) {
            this.description = description;
            return this;
        }

        public OAuth2SecuritySchemeBuilder ref(String ref) {
            this.ref = ref;
            return this;
        }

        public OAuth2SecurityScheme build() {
            return new OAuth2SecurityScheme(this.flows, this.scopes, this.description, this.ref);
        }

        public String toString() {
            return "OAuth2SecurityScheme.OAuth2SecuritySchemeBuilder(flows=" + this.flows + ", scopes=" + this.scopes + ", description=" + this.description + ", ref=" + this.ref + ")";
        }
    }
}

