/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.asyncapi.v3.model.security_scheme.oauth2.flows;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.springwolf.asyncapi.v3.model.security_scheme.oauth2.flows.OAuthFlow;
import jakarta.validation.constraints.NotNull;
import java.util.Map;

public class AuthorizationCodeOAuthFlow
extends OAuthFlow {
    @NotNull
    @JsonProperty(value="authorizationUrl")
    private String authorizationUrl;
    @JsonProperty(value="tokenUrl")
    private String tokenUrl;

    public AuthorizationCodeOAuthFlow(String refreshUrl, @NotNull Map<String, String> availableScopes, @NotNull String authorizationUrl, String tokenUrl) {
        super(refreshUrl, availableScopes);
        this.authorizationUrl = authorizationUrl;
        this.tokenUrl = tokenUrl;
    }

    public static AuthorizationCodeOAuthFlowBuilder authorizationCodeBuilder() {
        return new AuthorizationCodeOAuthFlowBuilder();
    }

    public String getAuthorizationUrl() {
        return this.authorizationUrl;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    @JsonProperty(value="authorizationUrl")
    public void setAuthorizationUrl(String authorizationUrl) {
        this.authorizationUrl = authorizationUrl;
    }

    @JsonProperty(value="tokenUrl")
    public void setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
    }

    @Override
    public String toString() {
        return "AuthorizationCodeOAuthFlow(authorizationUrl=" + this.getAuthorizationUrl() + ", tokenUrl=" + this.getTokenUrl() + ")";
    }

    public AuthorizationCodeOAuthFlow() {
    }

    public AuthorizationCodeOAuthFlow(String authorizationUrl, String tokenUrl) {
        this.authorizationUrl = authorizationUrl;
        this.tokenUrl = tokenUrl;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthorizationCodeOAuthFlow)) {
            return false;
        }
        AuthorizationCodeOAuthFlow other = (AuthorizationCodeOAuthFlow)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$authorizationUrl = this.getAuthorizationUrl();
        String other$authorizationUrl = other.getAuthorizationUrl();
        if (this$authorizationUrl == null ? other$authorizationUrl != null : !this$authorizationUrl.equals(other$authorizationUrl)) {
            return false;
        }
        String this$tokenUrl = this.getTokenUrl();
        String other$tokenUrl = other.getTokenUrl();
        return !(this$tokenUrl == null ? other$tokenUrl != null : !this$tokenUrl.equals(other$tokenUrl));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AuthorizationCodeOAuthFlow;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $authorizationUrl = this.getAuthorizationUrl();
        result = result * 59 + ($authorizationUrl == null ? 43 : $authorizationUrl.hashCode());
        String $tokenUrl = this.getTokenUrl();
        result = result * 59 + ($tokenUrl == null ? 43 : $tokenUrl.hashCode());
        return result;
    }

    public static class AuthorizationCodeOAuthFlowBuilder {
        private String refreshUrl;
        private Map<String, String> availableScopes;
        private String authorizationUrl;
        private String tokenUrl;

        AuthorizationCodeOAuthFlowBuilder() {
        }

        public AuthorizationCodeOAuthFlowBuilder refreshUrl(String refreshUrl) {
            this.refreshUrl = refreshUrl;
            return this;
        }

        public AuthorizationCodeOAuthFlowBuilder availableScopes(Map<String, String> availableScopes) {
            this.availableScopes = availableScopes;
            return this;
        }

        public AuthorizationCodeOAuthFlowBuilder authorizationUrl(String authorizationUrl) {
            this.authorizationUrl = authorizationUrl;
            return this;
        }

        public AuthorizationCodeOAuthFlowBuilder tokenUrl(String tokenUrl) {
            this.tokenUrl = tokenUrl;
            return this;
        }

        public AuthorizationCodeOAuthFlow build() {
            return new AuthorizationCodeOAuthFlow(this.refreshUrl, this.availableScopes, this.authorizationUrl, this.tokenUrl);
        }

        public String toString() {
            return "AuthorizationCodeOAuthFlow.AuthorizationCodeOAuthFlowBuilder(refreshUrl=" + this.refreshUrl + ", availableScopes=" + this.availableScopes + ", authorizationUrl=" + this.authorizationUrl + ", tokenUrl=" + this.tokenUrl + ")";
        }
    }
}

