// SPDX-License-Identifier: Apache-2.0
package io.github.springwolf.asyncapi.v3.model.security_scheme;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class HttpSecurityScheme extends SecurityScheme {

    /**
     * REQUIRED. The name of the HTTP Authorization scheme to be used in the Authorization header as defined in RFC7235.
     */
    @NotNull
    @JsonProperty("scheme")
    private String scheme;

    /**
     * A hint to the client to identify how the bearer token is formatted. Bearer tokens are usually generated by an
     * authorization server, so this information is primarily for documentation purposes.
     */
    @JsonProperty("bearerFormat")
    private String bearerFormat;

    @Builder(builderMethodName = "httpBuilder")
    public HttpSecurityScheme(String scheme, String bearerFormat, String description, String ref) {
        super(SecurityType.HTTP, description, ref);
        this.scheme = scheme;
        this.bearerFormat = bearerFormat;
    }
}
