/*
 * Decompiled with CFR 0.152.
 */
package io.github.stavshamir.springwolf.asyncapi.scanners.channels.cloudstream;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

class FunctionalChannelBeanData {
    private final String beanName;
    private final Class<?> payloadType;
    private final BeanType beanType;
    private final String cloudStreamBinding;

    static Set<FunctionalChannelBeanData> fromMethodBean(Method methodBean) {
        Class<?> returnType = methodBean.getReturnType();
        if (Consumer.class.isAssignableFrom(returnType)) {
            Class<?> payloadType = FunctionalChannelBeanData.getReturnTypeGenerics(methodBean).get(0);
            return Set.of(FunctionalChannelBeanData.ofConsumer(methodBean.getName(), payloadType));
        }
        if (Supplier.class.isAssignableFrom(returnType)) {
            Class<?> payloadType = FunctionalChannelBeanData.getReturnTypeGenerics(methodBean).get(0);
            return Set.of(FunctionalChannelBeanData.ofSupplier(methodBean.getName(), payloadType));
        }
        if (Function.class.isAssignableFrom(returnType)) {
            return FunctionalChannelBeanData.fromFunctionBean(methodBean);
        }
        return Collections.emptySet();
    }

    private static FunctionalChannelBeanData ofConsumer(String name, Class<?> payloadType) {
        return new FunctionalChannelBeanData(name, payloadType, BeanType.CONSUMER, name + "-in-0");
    }

    private static FunctionalChannelBeanData ofSupplier(String name, Class<?> payloadType) {
        return new FunctionalChannelBeanData(name, payloadType, BeanType.SUPPLIER, name + "-out-0");
    }

    private static Set<FunctionalChannelBeanData> fromFunctionBean(Method methodBean) {
        String name = methodBean.getName();
        Class<?> inputType = FunctionalChannelBeanData.getReturnTypeGenerics(methodBean).get(0);
        Class<?> outputType = FunctionalChannelBeanData.getReturnTypeGenerics(methodBean).get(1);
        return Set.of(FunctionalChannelBeanData.ofConsumer(name, inputType), FunctionalChannelBeanData.ofSupplier(name, outputType));
    }

    private static List<Class<?>> getReturnTypeGenerics(Method methodBean) {
        ParameterizedType genericReturnType = (ParameterizedType)methodBean.getGenericReturnType();
        return Arrays.stream(genericReturnType.getActualTypeArguments()).map(FunctionalChannelBeanData::toClassObject).collect(Collectors.toList());
    }

    private static Class<?> toClassObject(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type).getRawType();
            if ("org.apache.kafka.streams.kstream.KStream".equals(rawType.getTypeName())) {
                return (Class)((ParameterizedType)type).getActualTypeArguments()[1];
            }
            return (Class)rawType;
        }
        throw new IllegalArgumentException("Cannot handle Type which is not Class or ParameterizedType, but was given: " + type.getClass());
    }

    public FunctionalChannelBeanData(String beanName, Class<?> payloadType, BeanType beanType, String cloudStreamBinding) {
        this.beanName = beanName;
        this.payloadType = payloadType;
        this.beanType = beanType;
        this.cloudStreamBinding = cloudStreamBinding;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public Class<?> getPayloadType() {
        return this.payloadType;
    }

    public BeanType getBeanType() {
        return this.beanType;
    }

    public String getCloudStreamBinding() {
        return this.cloudStreamBinding;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FunctionalChannelBeanData)) {
            return false;
        }
        FunctionalChannelBeanData other = (FunctionalChannelBeanData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$beanName = this.getBeanName();
        String other$beanName = other.getBeanName();
        if (this$beanName == null ? other$beanName != null : !this$beanName.equals(other$beanName)) {
            return false;
        }
        Class<?> this$payloadType = this.getPayloadType();
        Class<?> other$payloadType = other.getPayloadType();
        if (this$payloadType == null ? other$payloadType != null : !this$payloadType.equals(other$payloadType)) {
            return false;
        }
        BeanType this$beanType = this.getBeanType();
        BeanType other$beanType = other.getBeanType();
        if (this$beanType == null ? other$beanType != null : !((Object)((Object)this$beanType)).equals((Object)other$beanType)) {
            return false;
        }
        String this$cloudStreamBinding = this.getCloudStreamBinding();
        String other$cloudStreamBinding = other.getCloudStreamBinding();
        return !(this$cloudStreamBinding == null ? other$cloudStreamBinding != null : !this$cloudStreamBinding.equals(other$cloudStreamBinding));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FunctionalChannelBeanData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $beanName = this.getBeanName();
        result = result * 59 + ($beanName == null ? 43 : $beanName.hashCode());
        Class<?> $payloadType = this.getPayloadType();
        result = result * 59 + ($payloadType == null ? 43 : $payloadType.hashCode());
        BeanType $beanType = this.getBeanType();
        result = result * 59 + ($beanType == null ? 43 : ((Object)((Object)$beanType)).hashCode());
        String $cloudStreamBinding = this.getCloudStreamBinding();
        result = result * 59 + ($cloudStreamBinding == null ? 43 : $cloudStreamBinding.hashCode());
        return result;
    }

    public String toString() {
        return "FunctionalChannelBeanData(beanName=" + this.getBeanName() + ", payloadType=" + this.getPayloadType() + ", beanType=" + this.getBeanType() + ", cloudStreamBinding=" + this.getCloudStreamBinding() + ")";
    }

    static enum BeanType {
        CONSUMER,
        SUPPLIER;

    }
}

