/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.addons.json_schema;

import io.github.springwolf.addons.json_schema.JsonSchemaGenerator;
import io.github.springwolf.asyncapi.v3.model.AsyncAPI;
import io.github.springwolf.asyncapi.v3.model.schema.SchemaObject;
import io.github.springwolf.core.asyncapi.AsyncApiCustomizer;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSchemaCustomizer
implements AsyncApiCustomizer {
    private static final Logger log = LoggerFactory.getLogger(JsonSchemaCustomizer.class);
    private static final String EXTENSION_JSON_SCHEMA = "x-json-schema";
    private final JsonSchemaGenerator jsonSchemaGenerator;

    public void customize(AsyncAPI asyncAPI) {
        Map schemas = asyncAPI.getComponents().getSchemas();
        for (Map.Entry entry : schemas.entrySet()) {
            SchemaObject schema = (SchemaObject)entry.getValue();
            if (schema == null) continue;
            if (schema.getExtensionFields() == null) {
                schema.setExtensionFields(new HashMap());
            }
            try {
                log.debug("Generate json-schema for {}", entry.getKey());
                Object jsonSchema = this.jsonSchemaGenerator.fromSchema(schema, schemas);
                schema.getExtensionFields().putIfAbsent(EXTENSION_JSON_SCHEMA, jsonSchema);
            }
            catch (Exception ex) {
                log.warn("Unable to create json-schema for {}", entry.getKey(), (Object)ex);
            }
        }
    }

    public JsonSchemaCustomizer(JsonSchemaGenerator jsonSchemaGenerator) {
        this.jsonSchemaGenerator = jsonSchemaGenerator;
    }
}

