/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.addons.json_schema;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.github.springwolf.asyncapi.v3.model.components.ComponentSchema;
import io.github.springwolf.asyncapi.v3.model.schema.SchemaObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class JsonSchemaGenerator {
    private final ObjectMapper objectMapper;

    public Object fromSchema(SchemaObject schema, Map<String, SchemaObject> definitions) throws JsonProcessingException {
        ObjectNode node = this.fromSchemaInternal(schema, definitions, new HashSet<SchemaObject>());
        node.put("$schema", "https://json-schema.org/draft-04/schema#");
        return this.objectMapper.readValue(node.toString(), Object.class);
    }

    private ObjectNode fromSchemaInternal(SchemaObject schema, Map<String, SchemaObject> definitions, Set<SchemaObject> visited) {
        if (schema != null && !visited.contains(schema)) {
            visited.add(schema);
            return this.mapToJsonSchema(schema, definitions, visited);
        }
        return this.objectMapper.createObjectNode();
    }

    private ObjectNode mapToJsonSchema(SchemaObject schema, Map<String, SchemaObject> definitions, Set<SchemaObject> visited) {
        SchemaObject schemaObject;
        SchemaObject schemaObject2;
        ArrayNode arrayNode;
        ObjectNode node = this.objectMapper.createObjectNode();
        if (schema.getAnyOf() != null) {
            arrayNode = this.objectMapper.createArrayNode();
            for (ComponentSchema ofSchema : schema.getAnyOf()) {
                schemaObject2 = JsonSchemaGenerator.getSchemaObject(ofSchema, definitions);
                arrayNode.add((JsonNode)this.fromSchemaInternal(schemaObject2, definitions, visited));
            }
            node.set("anyOf", (JsonNode)arrayNode);
        }
        if (schema.getAllOf() != null) {
            arrayNode = this.objectMapper.createArrayNode();
            for (ComponentSchema allSchema : schema.getAllOf()) {
                schemaObject2 = JsonSchemaGenerator.getSchemaObject(allSchema, definitions);
                arrayNode.add((JsonNode)this.fromSchemaInternal(schemaObject2, definitions, visited));
            }
            node.set("allOf", (JsonNode)arrayNode);
        }
        if (schema.getConstValue() != null) {
            node.put("const", schema.getConstValue().toString());
        }
        if (schema.getDescription() != null) {
            node.put("description", schema.getDescription());
        }
        if (schema.getEnumValues() != null) {
            arrayNode = this.objectMapper.createArrayNode();
            for (Object property : schema.getEnumValues()) {
                arrayNode.add(property.toString());
            }
            node.set("enum", (JsonNode)arrayNode);
        }
        if (schema.getExclusiveMinimum() != null) {
            node.put("exclusiveMinimum", schema.getExclusiveMinimum());
        }
        if (schema.getExclusiveMaximum() != null) {
            node.put("exclusiveMaximum", schema.getExclusiveMaximum());
        }
        if (schema.getFormat() != null) {
            node.put("format", schema.getFormat());
        }
        if (schema.getItems() != null) {
            schemaObject = JsonSchemaGenerator.getSchemaObject(schema.getItems(), definitions);
            node.set("items", (JsonNode)this.fromSchemaInternal(schemaObject, definitions, visited));
        }
        if (schema.getMaximum() != null) {
            node.put("maximum", schema.getMaximum());
        }
        if (schema.getMinimum() != null) {
            node.put("minimum", schema.getMinimum());
        }
        if (schema.getMaxItems() != null) {
            node.put("maxItems", schema.getMaxItems());
        }
        if (schema.getMinItems() != null) {
            node.put("minItems", schema.getMinItems());
        }
        if (schema.getMaxLength() != null) {
            node.put("maxLength", schema.getMaxLength());
        }
        if (schema.getMinLength() != null) {
            node.put("minLength", schema.getMinLength());
        }
        if (schema.getMultipleOf() != null) {
            node.put("multipleOf", schema.getMultipleOf());
        }
        if (schema.getNot() != null) {
            schemaObject = JsonSchemaGenerator.getSchemaObject(schema.getNot(), definitions);
            node.set("not", (JsonNode)this.fromSchemaInternal(schemaObject, definitions, visited));
        }
        if (schema.getOneOf() != null) {
            arrayNode = this.objectMapper.createArrayNode();
            for (ComponentSchema ofSchema : schema.getOneOf()) {
                schemaObject2 = JsonSchemaGenerator.getSchemaObject(ofSchema, definitions);
                arrayNode.add((JsonNode)this.fromSchemaInternal(schemaObject2, definitions, visited));
            }
            node.set("oneOf", (JsonNode)arrayNode);
        }
        if (schema.getPattern() != null) {
            node.put("pattern", schema.getPattern());
        }
        if (schema.getProperties() != null && !schema.getProperties().isEmpty()) {
            node.set("properties", this.buildProperties(schema, definitions, visited));
        }
        if (schema.getRequired() != null) {
            arrayNode = this.objectMapper.createArrayNode();
            for (Object property : schema.getRequired()) {
                arrayNode.add(property);
            }
            node.set("required", (JsonNode)arrayNode);
        }
        if (schema.getTitle() != null) {
            node.put("title", schema.getTitle());
        }
        if (schema.getType() != null) {
            node.put("type", schema.getType());
        }
        if (schema.getUniqueItems() != null) {
            node.put("uniqueItems", schema.getUniqueItems());
        }
        return node;
    }

    private JsonNode buildProperties(SchemaObject schema, Map<String, SchemaObject> definitions, Set<SchemaObject> visited) {
        ObjectNode node = this.objectMapper.createObjectNode();
        for (Map.Entry propertySchemaSet : schema.getProperties().entrySet()) {
            SchemaObject propertySchema = JsonSchemaGenerator.getSchemaObject(propertySchemaSet.getValue(), definitions);
            ObjectNode propertySchemaMapped = this.fromSchemaInternal(propertySchema, definitions, visited);
            node.set((String)propertySchemaSet.getKey(), (JsonNode)propertySchemaMapped);
        }
        return node;
    }

    private static SchemaObject getSchemaObject(Object schema, Map<String, SchemaObject> definitions) {
        if (schema instanceof SchemaObject) {
            return (SchemaObject)schema;
        }
        if (schema instanceof ComponentSchema) {
            ComponentSchema componentSchema = (ComponentSchema)schema;
            if (componentSchema.getReference() != null && componentSchema.getReference().getRef() != null) {
                String schemaName = StringUtils.substringAfterLast((String)componentSchema.getReference().getRef(), (String)"/");
                return definitions.get(schemaName);
            }
            return componentSchema.getSchema();
        }
        return null;
    }

    public JsonSchemaGenerator(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

