/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.bindings.kafka.scanners.operations;

import io.github.springwolf.asyncapi.v3.bindings.OperationBinding;
import io.github.springwolf.asyncapi.v3.bindings.kafka.KafkaOperationBinding;
import io.github.springwolf.asyncapi.v3.model.schema.Schema;
import io.github.springwolf.asyncapi.v3.model.schema.SchemaObject;
import io.github.springwolf.bindings.kafka.annotations.KafkaAsyncOperationBinding;
import io.github.springwolf.core.asyncapi.scanners.bindings.operations.AbstractOperationBindingProcessor;
import io.github.springwolf.core.asyncapi.scanners.bindings.operations.ProcessedOperationBinding;
import jakarta.annotation.Nullable;
import java.util.List;
import org.springframework.util.StringUtils;

public class KafkaOperationBindingProcessor
extends AbstractOperationBindingProcessor<KafkaAsyncOperationBinding> {
    protected ProcessedOperationBinding mapToOperationBinding(KafkaAsyncOperationBinding bindingAnnotation) {
        String clientId = this.resolveOrNull(bindingAnnotation.clientId());
        SchemaObject clientIdSchema = KafkaOperationBindingProcessor.createStringSchema(clientId);
        String groupId = this.resolveOrNull(bindingAnnotation.groupId());
        SchemaObject groupIdSchema = KafkaOperationBindingProcessor.createStringSchema(groupId);
        KafkaOperationBinding.KafkaOperationBindingBuilder kafkaOperationBindingBuilder = KafkaOperationBinding.builder();
        kafkaOperationBindingBuilder.clientId((Schema)clientIdSchema).groupId((Schema)groupIdSchema);
        String bindingVersion = this.resolveOrNull(bindingAnnotation.bindingVersion());
        if (StringUtils.hasText((String)bindingVersion)) {
            kafkaOperationBindingBuilder.bindingVersion(bindingVersion);
        }
        return new ProcessedOperationBinding("kafka", (OperationBinding)kafkaOperationBindingBuilder.build());
    }

    @Nullable
    private static SchemaObject createStringSchema(String value) {
        if (value != null && !value.isEmpty()) {
            SchemaObject schema = new SchemaObject();
            schema.setEnumValues(List.of(value));
            schema.setType("string");
            return schema;
        }
        return null;
    }
}

