/*
 * Decompiled with CFR 0.152.
 */
package io.github.stavshamir.springwolf.asyncapi.scanners.channels.annotation;

import com.asyncapi.v2.binding.ChannelBinding;
import com.asyncapi.v2.binding.OperationBinding;
import com.asyncapi.v2.binding.kafka.KafkaChannelBinding;
import com.asyncapi.v2.binding.kafka.KafkaOperationBinding;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.util.StringValueResolver;

public class KafkaListenerUtil {
    private static final Logger log = LoggerFactory.getLogger(KafkaListenerUtil.class);

    public static String getChannelName(KafkaListener annotation, StringValueResolver resolver) {
        List resolvedTopics = Arrays.stream(annotation.topics()).map(arg_0 -> ((StringValueResolver)resolver).resolveStringValue(arg_0)).collect(Collectors.toList());
        log.debug("Found topics: {}", (Object)String.join((CharSequence)", ", resolvedTopics));
        return (String)resolvedTopics.get(0);
    }

    public static Map<String, ? extends ChannelBinding> buildChannelBinding() {
        return ImmutableMap.of((Object)"kafka", (Object)new KafkaChannelBinding());
    }

    public static Map<String, ? extends OperationBinding> buildOperationBinding(KafkaListener annotation, StringValueResolver resolver) {
        String groupId = resolver.resolveStringValue(annotation.groupId());
        if (groupId == null || groupId.isEmpty()) {
            log.debug("No group ID found for this listener");
            groupId = null;
        } else {
            log.debug("Found group id: {}", (Object)groupId);
        }
        KafkaOperationBinding binding = new KafkaOperationBinding();
        binding.setGroupId((Object)groupId);
        return ImmutableMap.of((Object)"kafka", (Object)binding);
    }
}

